/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import javax.swing.Icon;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.gui.renderer.FWTableCellRenderer;
import phex.gui.tabs.library.HalfGrayedImageFilter;
import phex.share.ShareFile;

public class FileSystemTableCellRenderer
extends FWTableCellRenderer {
    private Icon sharedIcon;
    private Icon unsharedIcon;

    public FileSystemTableCellRenderer() {
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.sharedIcon = iconFactory.getIcon("File");
        this.unsharedIcon = HalfGrayedImageFilter.createGrayIcon(iconFactory.getIcon("File"));
    }

    protected void setValue(Object object) {
        if (object instanceof ShareFile) {
            ShareFile shareFile = (ShareFile)object;
            this.setText(shareFile.getFileName());
            this.setIcon(this.sharedIcon);
        } else if (object instanceof File) {
            File file = (File)object;
            this.setText(file.getName());
            this.setIcon(this.unsharedIcon);
        } else {
            this.setText(object.toString());
            this.setIcon(null);
        }
    }
}

