/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.SystemUtils;
import phex.event.ShareChangeListener;
import phex.share.ShareManager;
import phex.utils.DirectoryOnlyFileFilter;

public class FileSystemTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();
    private FileFilter dirFilter = new DirectoryOnlyFileFilter();
    private File[] fsRoots;
    private Object root = new String("ROOT");

    public FileSystemTreeModel() {
        this.updateFileSystem();
        FileSystemChangeListener fileSystemChangeListener = new FileSystemChangeListener();
        ShareManager.getInstance().getSharedFilesService().addSharedFilesChangeListener(fileSystemChangeListener);
    }

    public void updateFileSystem() {
        File[] fileArray = File.listRoots();
        if (SystemUtils.IS_OS_WINDOWS) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getAbsolutePath();
                if (string.startsWith("A:") || string.startsWith("B:") || !this.checkFsAccess(fileArray[i])) continue;
                arrayList.add(fileArray[i]);
            }
            this.fsRoots = new File[arrayList.size()];
            arrayList.toArray(this.fsRoots);
        } else {
            this.fsRoots = fileArray;
        }
        this.fireTreeStructureChanged();
    }

    private boolean checkFsAccess(File file) {
        return true;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        if (object.equals(this.root)) {
            return this.fsRoots[n];
        }
        return ((File)object).listFiles(this.dirFilter)[n];
    }

    public int getChildCount(Object object) {
        if (object.equals(this.root)) {
            return this.fsRoots.length;
        }
        File[] fileArray = ((File)object).listFiles(this.dirFilter);
        if (fileArray == null) {
            return 0;
        }
        return fileArray.length;
    }

    public boolean isLeaf(Object object) {
        return false;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    private void fireTreeStructureChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TreeModelListener == null ? FileSystemTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)this, (TreePath)null);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            FileSystemTreeModel.this.fireTreeStructureChanged();
        }
    }
}

