/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.gui.tabs.library.HalfGrayedImageFilter;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import sun.awt.shell.ShellFolder;

public class FileSystemTreeRenderer
extends DefaultTreeCellRenderer {
    private Icon sharedOpenIcon;
    private Icon sharedClosedIcon;
    private Icon unsharedOpenIcon;
    private Icon unsharedClosedIcon;
    private Icon partlySharedOpenIcon;
    private Icon partlySharedClosedIcon;

    public FileSystemTreeRenderer() {
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.setOpenIcon(iconFactory.getIcon("FileTreeOpen"));
        this.setClosedIcon(iconFactory.getIcon("FileTreeClosed"));
        this.sharedOpenIcon = iconFactory.getIcon("FileTreeClosed");
        this.sharedClosedIcon = iconFactory.getIcon("FileTreeClosed");
        this.partlySharedOpenIcon = HalfGrayedImageFilter.createHalfGrayIcon(iconFactory.getIcon("FileTreeClosed"));
        this.partlySharedClosedIcon = HalfGrayedImageFilter.createHalfGrayIcon(iconFactory.getIcon("FileTreeClosed"));
        this.unsharedOpenIcon = HalfGrayedImageFilter.createGrayIcon(iconFactory.getIcon("FileTreeClosed"));
        this.unsharedClosedIcon = HalfGrayedImageFilter.createGrayIcon(iconFactory.getIcon("FileTreeClosed"));
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (object == jTree.getModel().getRoot()) {
            this.setIcon(null);
            this.setText("");
            this.setMinimumSize(new Dimension(0, 0));
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
            return this;
        }
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.setMaximumSize(null);
        File file = (File)object;
        String string = file.getName();
        if ((string == null || string.length() == 0) && file.exists()) {
            try {
                string = ShellFolder.getShellFolder(file).getDisplayName();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (string == null || string.length() == 0) {
            string = file.getPath();
        }
        this.setText(string);
        SharedDirectory sharedDirectory = ShareManager.getInstance().getSharedFilesService().getSharedDirectory(file);
        if (sharedDirectory == null) {
            if (bl2) {
                this.setIcon(this.unsharedOpenIcon);
            } else {
                this.setIcon(this.unsharedClosedIcon);
            }
        } else if (sharedDirectory.getType() == 2) {
            if (bl2) {
                this.setIcon(this.partlySharedOpenIcon);
            } else {
                this.setIcon(this.partlySharedClosedIcon);
            }
        } else if (sharedDirectory.getType() == 1) {
            if (bl2) {
                this.setIcon(this.sharedOpenIcon);
            } else {
                this.setIcon(this.sharedClosedIcon);
            }
        }
        return this;
    }
}

