/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SystemUtils;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.event.SharedFilesChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.actions.FWToggleAction;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.dialogs.ExportDialog;
import phex.gui.dialogs.FilterLibraryDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.library.FileSystemTreeModel;
import phex.gui.tabs.library.FileSystemTreeRenderer;
import phex.gui.tabs.library.SharedFilesTableModel;
import phex.share.FileRescanRunner;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.share.SharedResource;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.URLUtil;
import phex.utils.WindowsShellExecute;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class LibraryTab
extends FWTab {
    private static final String SHARED_FILES_TABLE_IDENTIFIER = "SharedFilesTable";
    private JLabel sharedFilesLabel;
    private FWTable sharedFilesTable;
    private JTree mainTree;
    private FileSystemTreeModel fileSystemTreeModel;
    private FWPopupMenu fileTreePopup;
    private FWPopupMenu fileTablePopup;
    private JScrollPane sharedFilesTableScrollPane;
    private SharedFilesTableModel sharedFilesModel;
    private FWTableColumnModel sharedFilesColumnModel;

    public LibraryTab() {
        super(1007, Localizer.getString("Library"), GUIRegistry.getInstance().getIconFactory().getIcon("Library"), Localizer.getString("TTTLibrary"), Localizer.getChar("LibraryMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("LibraryAccelerator")), 5);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, p, 3dlu, fill:d:grow, 1dlu, p, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.addSeparator(Localizer.getString("Library"), cellConstraints.xywh(2, 2, 1, 1));
        MouseHandler mouseHandler = new MouseHandler();
        this.fileSystemTreeModel = new FileSystemTreeModel();
        this.mainTree = new JTree(this.fileSystemTreeModel);
        this.mainTree.setMinimumSize(new Dimension(0, 0));
        this.mainTree.setRowHeight(0);
        this.mainTree.setCellRenderer(new FileSystemTreeRenderer());
        this.mainTree.addMouseListener(mouseHandler);
        this.mainTree.getSelectionModel().addTreeSelectionListener(new SelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.mainTree);
        this.sharedFilesModel = new SharedFilesTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SHARED_FILES_TABLE_IDENTIFIER);
        this.buildSharedFilesTableColumnModel(xJBGUITable);
        this.sharedFilesTable = new FWTable((TableModel)new FWSortedTableModel(this.sharedFilesModel), this.sharedFilesColumnModel);
        this.sharedFilesTable.activateAllHeaderActions();
        this.sharedFilesTable.setAutoResizeMode(0);
        this.sharedFilesTable.addMouseListener(mouseHandler);
        this.sharedFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.sharedFilesTableScrollPane = FWTable.createFWTableScrollPane(this.sharedFilesTable);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.sharedFilesTableScrollPane);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        panelBuilder.add((Component)jSplitPane, cellConstraints.xywh(2, 4, 1, 1));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        panelBuilder.add((Component)fWToolBar, cellConstraints.xy(2, 6));
        this.fileTreePopup = new FWPopupMenu();
        this.fileTablePopup = new FWPopupMenu();
        FWAction fWAction = new ShareFolderAction();
        this.addTabAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        fWAction = new ShareFolderRecursiveAction(true);
        this.addTabAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWAction = new ShareFolderRecursiveAction(false);
        this.addTabAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        fWToolBar.addAction(fWAction);
        fWToolBar.addSeparator();
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.fileTablePopup.addAction(fWAction);
        if (SystemUtils.IS_OS_WINDOWS) {
            fWAction = new OpenFileAction();
            this.addTabAction(fWAction);
            fWToolBar.addAction(fWAction);
            this.fileTablePopup.addAction(fWAction);
        }
        fWToolBar.addSeparator();
        this.fileTreePopup.addSeparator();
        this.fileTablePopup.addSeparator();
        fWAction = new RescanAction();
        fWToolBar.addAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        this.fileTablePopup.addAction(fWAction);
        fWAction = new ExportAction();
        fWToolBar.addAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        this.fileTablePopup.addAction(fWAction);
        fWAction = new FilterAction();
        fWToolBar.addAction(fWAction);
        this.fileTreePopup.addAction(fWAction);
        this.fileTablePopup.addAction(fWAction);
    }

    public void updateUI() {
        super.updateUI();
        if (this.sharedFilesTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.sharedFilesTableScrollPane);
        }
    }

    private File getSelectedTreeComponent() {
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        File file = (File)treePath.getLastPathComponent();
        return file;
    }

    private void buildSharedFilesTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SharedFilesTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.sharedFilesColumnModel = new FWTableColumnModel(this.sharedFilesModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.sharedFilesColumnModel.createXJBGUITableColumnList();
        ObjectFactory objectFactory = new ObjectFactory();
        XJBGUITable xJBGUITable = objectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SHARED_FILES_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == LibraryTab.this.mainTree) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTreePopup.show(component, n, n2);
            } else if (component == LibraryTab.this.sharedFilesTable) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTablePopup.show(component, n, n2);
            }
        }
    }

    private class SharedFilesChangeHandler
    implements SharedFilesChangeListener {
        private SharedFilesChangeHandler() {
        }

        public void sharedFileChanged(int n) {
        }

        public void sharedFileAdded(int n) {
            this.updateLabel();
        }

        public void sharedFileRemoved(int n) {
            this.updateLabel();
        }

        public void allSharedFilesChanged() {
            this.updateLabel();
        }

        private void updateLabel() {
        }
    }

    private class SelectionHandler
    implements ListSelectionListener,
    TreeSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                LibraryTab.this.refreshTabActions();
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            final Object object = LibraryTab.this.fileSystemTreeModel.getRoot();
            if (treeSelectionEvent.getPath().getLastPathComponent() == object) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LibraryTab.this.mainTree.setSelectionPath(new TreePath(new Object[]{object, LibraryTab.this.fileSystemTreeModel.getChild(object, 0)}));
                    }
                });
                return;
            }
            LibraryTab.this.sharedFilesModel.setDisplayDirectory((File)treeSelectionEvent.getPath().getLastPathComponent());
            LibraryTab.this.refreshTabActions();
        }
    }

    class ShareFolderRecursiveAction
    extends FWAction {
        private boolean doSharing;

        ShareFolderRecursiveAction(boolean bl) {
            super(null);
            this.doSharing = bl;
            if (this.doSharing) {
                this.setName(Localizer.getString("ShareFolderRecursive"));
                this.setToolTipText(Localizer.getString("TTTShareFolderRecursive"));
                this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolderRec"));
            } else {
                this.setName(Localizer.getString("UnShareFolderRecursive"));
                this.setToolTipText(Localizer.getString("TTTUnShareFolderRecursive"));
                this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolderClear"));
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    File file = LibraryTab.this.getSelectedTreeComponent();
                    if (file == null) {
                        return;
                    }
                    ShareFolderRecursiveAction.this.shareDirRecursive(file);
                    FileRescanRunner.rescan(true, true);
                }
            };
            ThreadPool.getInstance().addJob(runnable, "Recursive Share/Unshare");
            this.refreshActionState();
        }

        private void shareDirRecursive(File file) {
            File[] fileArray;
            if (!file.isDirectory()) {
                return;
            }
            if (this.doSharing) {
                ServiceManager.sCfg.sharedDirectoriesSet.add(file.getAbsolutePath());
            } else {
                ServiceManager.sCfg.sharedDirectoriesSet.remove(file.getAbsolutePath());
                fileArray = ShareManager.getInstance().getSharedFilesService();
                SharedDirectory sharedDirectory = fileArray.getSharedDirectory(file);
                if (sharedDirectory == null) {
                    return;
                }
            }
            fileArray = file.listFiles(new DirectoryOnlyFileFilter());
            for (int i = 0; i < fileArray.length; ++i) {
                this.shareDirRecursive(fileArray[i]);
            }
        }

        public void refreshActionState() {
        }
    }

    class ShareFolderAction
    extends FWToggleAction {
        ShareFolderAction() {
            super(Localizer.getString("ShareFolder"), GUIRegistry.getInstance().getIconFactory().getIcon("ShareFolder"), Localizer.getString("TTTShareFolder"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = LibraryTab.this.getSelectedTreeComponent();
            if (file == null) {
                return;
            }
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            SharedDirectory sharedDirectory = sharedFilesService.getSharedDirectory(file);
            if (sharedDirectory != null && sharedDirectory.getType() == 1) {
                ServiceManager.sCfg.sharedDirectoriesSet.remove(file.getAbsolutePath());
            } else {
                ServiceManager.sCfg.sharedDirectoriesSet.add(file.getAbsolutePath());
            }
            FileRescanRunner.rescan(true, true);
            this.refreshActionState();
        }

        public void refreshActionState() {
            File file = LibraryTab.this.getSelectedTreeComponent();
            if (file == null) {
                this.setSelected(false);
                return;
            }
            SharedDirectory sharedDirectory = ShareManager.getInstance().getSharedFilesService().getSharedDirectory(file);
            if (sharedDirectory != null && sharedDirectory.getType() == 1) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
        }
    }

    private class FilterAction
    extends FWAction {
        public FilterAction() {
            super(Localizer.getString("LibraryTab_Filter"), GUIRegistry.getInstance().getIconFactory().getIcon("Filter"), Localizer.getString("LibraryTab_TTTFilter"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FilterLibraryDialog filterLibraryDialog = new FilterLibraryDialog();
            filterLibraryDialog.show();
        }

        public void refreshActionState() {
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Object object = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
                if (object == null || !(object instanceof ShareFile)) {
                    return;
                }
                ShareFile shareFile = (ShareFile)object;
                URN uRN = shareFile.getURN();
                String string = URLUtil.buildBitziLookupURL(uRN);
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n2 = JOptionPane.showOptionDialog(LibraryTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n2 != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            Object object = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
            if (object == null || !(object instanceof ShareFile)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class OpenFileAction
    extends FWAction {
        OpenFileAction() {
            super(Localizer.getString("LibraryTab_OpenFile"), GUIRegistry.getInstance().getIconFactory().getIcon("Open"), Localizer.getString("LibraryTab_TTTOpenFile"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            Object object;
            int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            Object object2 = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
            if (object2 == null) {
                return;
            }
            if (object2 instanceof ShareFile) {
                object = (ShareFile)object2;
                file = ((SharedResource)object).getSystemFile();
            } else if (object2 instanceof File) {
                file = (File)object2;
            } else {
                return;
            }
            object = new Runnable(){

                public void run() {
                    WindowsShellExecute.executeViaShell(file.getAbsolutePath());
                }
            };
            ThreadPool.getInstance().addJob((Runnable)object, "WindowsShellExecute");
        }

        public void refreshActionState() {
            int n = LibraryTab.this.sharedFilesTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
                return;
            }
            Object object = LibraryTab.this.sharedFilesModel.getValueAt(n, 0);
            if (object == null) {
                this.setEnabled(false);
                return;
            }
            if (object instanceof ShareFile || object instanceof File) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ExportAction
    extends FWAction {
        ExportAction() {
            super(Localizer.getString("LibraryTab_Export"), GUIRegistry.getInstance().getIconFactory().getIcon("Export"), Localizer.getString("LibraryTab_TTTExport"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportDialog exportDialog = new ExportDialog();
            exportDialog.show();
        }

        public void refreshActionState() {
        }
    }

    class RescanAction
    extends FWAction {
        RescanAction() {
            super(Localizer.getString("LibraryTab_Rescan"), GUIRegistry.getInstance().getIconFactory().getIcon("Refresh"), Localizer.getString("LibraryTab_TTTRescan"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTab.this.fileSystemTreeModel.updateFileSystem();
            FileRescanRunner.rescan(true, true);
        }

        public void refreshActionState() {
        }
    }
}

