/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import phex.event.ShareChangeListener;
import phex.event.SharedFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.renderer.FileSizeCellRenderer;
import phex.gui.tabs.library.FileSystemTableCellRenderer;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.FilesOnlyFileFilter;
import phex.utils.Localizer;

public class SharedFilesTableModel
extends FWSortableTableModel {
    public static final int FILE_COLUMN_ID = 1001;
    public static final int DIRECTORY_COLUMN_ID = 1002;
    public static final int SIZE_COLUMN_ID = 1003;
    public static final int SEARCH_COUNT_COLUMN_ID = 1004;
    public static final int UPLOAD_COUNT_COLUMN_ID = 1005;
    public static final int SHA1_COLUMN_ID = 1006;
    public static final int THEX_COLUMN_ID = 1007;
    public static final int FILE_MODEL_INDEX = 0;
    public static final int DIRECTORY_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int SEARCH_COUNT_MODEL_INDEX = 3;
    public static final int UPLOAD_COUNT_MODEL_INDEX = 4;
    public static final int SHA1_MODEL_INDEX = 5;
    public static final int THEX_MODEL_INDEX = 6;
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Directory"), Localizer.getString("Size"), Localizer.getString("SearchCount"), Localizer.getString("UploadCount"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{FileSystemTableCellRenderer.class, String.class, FileSizeCellRenderer.class, Integer.class, Integer.class, String.class};
    private FileFilter fileFilter = new FilesOnlyFileFilter();
    private File displayDirectory;
    private File[] displayDirectryFiles;
    private SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();

    public SharedFilesTableModel() {
        super(tableColumns, tableClasses);
        FileSystemChangeListener fileSystemChangeListener = new FileSystemChangeListener();
        this.sharedFilesService.addSharedFilesChangeListener(fileSystemChangeListener);
    }

    public void setDisplayDirectory(File file) {
        this.displayDirectory = file;
        this.displayDirectryFiles = file.listFiles(this.fileFilter);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.displayDirectory == null) {
            return 0;
        }
        if (this.displayDirectryFiles == null) {
            return 0;
        }
        return this.displayDirectryFiles.length;
    }

    public Object getValueAt(int n, int n2) {
        if (this.displayDirectory == null) {
            return "";
        }
        if (n >= this.displayDirectryFiles.length) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        ShareFile shareFile = this.sharedFilesService.getShareFileByFile(this.displayDirectryFiles[n]);
        if (shareFile == null) {
            switch (n2) {
                case 0: {
                    return this.displayDirectryFiles[n];
                }
                case 1: {
                    return this.displayDirectryFiles[n].getParent();
                }
                case 2: {
                    return new Long(this.displayDirectryFiles[n].length());
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return "";
                }
                case 5: {
                    return "";
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    return shareFile;
                }
                case 1: {
                    return shareFile.getSystemFile().getParent();
                }
                case 2: {
                    return shareFile.getFileSizeObject();
                }
                case 3: {
                    return new Integer(shareFile.getSearchCount());
                }
                case 4: {
                    return new Integer(shareFile.getUploadCount());
                }
                case 5: {
                    return shareFile.getSHA1();
                }
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 2: {
                return FWSortedTableModel.COMPARABLE_COMAPRATOR;
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1006: {
                return 5;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006};
        return nArray;
    }

    private class SharedFilesListener
    implements SharedFilesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void sharedFileChanged(int n) {
            SharedFilesTableModel.this.fireTableCellUpdated(n, n);
        }

        public void sharedFileAdded(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, n, n, -1, 1));
        }

        public void sharedFileRemoved(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SharedFilesTableModel.this, n, n, -1, -1));
        }

        public void allSharedFilesChanged() {
            SharedFilesTableModel.this.fireTableDataChanged();
        }
    }

    public class FileSystemChangeListener
    implements ShareChangeListener {
        public void sharedDirectoriesChanged() {
            SharedFilesTableModel.this.fireTableDataChanged();
        }
    }
}

