/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.Keymap;
import phex.common.Cfg;
import phex.common.MediaType;
import phex.common.ServiceManager;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.gui.common.BoxPanel;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.common.LinkLabel;
import phex.gui.renderer.MediaTypeListRenderer;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.query.BrowseHostResults;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.query.SearchFilter;
import phex.utils.Localizer;
import phex.utils.Logger;

public class SearchControlPanel
extends JPanel
implements SearchChangeListener {
    private SizeDefinition[] sizeDefinitions = new SizeDefinition[]{new SizeDefinition("BytesToken", 1L), new SizeDefinition("KBToken", 1024L), new SizeDefinition("MBToken", 0x100000L), new SizeDefinition("GBToken", 0x40000000L)};
    private SearchContainer searchContainer;
    private SearchResultsDataModel displayedDataModel;
    private SearchTab searchTab;
    private BoxPanel searchBoxPanel;
    private DefaultComboBoxModel searchComboModel;
    private JComboBox searchTermComboBox;
    private JButton searchButton;
    private BoxPanel filterBoxPanel;
    private JTextField filterTextTF;
    private JComboBox mediaTypeComboBox;
    private JTextField minFileSizeTF;
    private JComboBox minFileSizeUnitComboBox;
    private JTextField maxFileSizeTF;
    private JComboBox maxFileSizeUnitComboBox;
    private JButton filterButton;

    public SearchControlPanel(SearchTab searchTab) {
        super(new GridBagLayout());
        this.searchTab = searchTab;
        this.searchContainer = QueryManager.getInstance().getSearchContainer();
        this.initializeComponent();
        this.updateUI();
    }

    public void clearSearchHistory() {
        this.searchComboModel.removeAllElements();
        ServiceManager.sCfg.searchTermHistory.clear();
        ServiceManager.sCfg.save();
    }

    public void initializeComponent() {
        Insets insets = new Insets(1, 1, 1, 3);
        this.searchBoxPanel = new BoxPanel(Localizer.getString("Search"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.searchBoxPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString("EnterSearchTerm"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.searchBoxPanel.addContent(jLabel, gridBagConstraints);
        SubmitSearchHandler submitSearchHandler = new SubmitSearchHandler();
        this.searchComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.searchTermHistory.toArray());
        this.searchTermComboBox = new JComboBox(this.searchComboModel);
        this.searchTermComboBox.setEditable(true);
        JTextField jTextField = (JTextField)this.searchTermComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("SearchTermEditor", jTextField.getKeymap());
        jTextField.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), submitSearchHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.searchTermComboBox);
        this.searchTermComboBox.setSelectedItem("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.searchBoxPanel.addContent(this.searchTermComboBox, gridBagConstraints);
        this.searchButton = new JButton(Localizer.getString("StartSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"));
        this.searchButton.setCursor(Cursor.getPredefinedCursor(12));
        this.searchButton.setToolTipText(Localizer.getString("TTTStartSearch"));
        this.searchButton.setMargin(insets);
        this.searchButton.addActionListener(submitSearchHandler);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 12, 5);
        this.searchBoxPanel.addContent(this.searchButton, gridBagConstraints);
        LinkLabel linkLabel = new LinkLabel(this.searchTab.getTabAction("CreateNewSearchAction"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.searchBoxPanel.addContent(linkLabel, gridBagConstraints);
        LinkLabel linkLabel2 = new LinkLabel(this.searchTab.getTabAction("CloseSearchAction"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.searchBoxPanel.addContent(linkLabel2, gridBagConstraints);
        this.filterBoxPanel = new BoxPanel(Localizer.getString("FilterResults"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.filterBoxPanel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("FilterText"));
        jLabel.setToolTipText(Localizer.getString("TTTFilterText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.filterBoxPanel.addContent(jLabel, gridBagConstraints);
        this.filterTextTF = new JTextField(8);
        this.filterTextTF.setToolTipText(Localizer.getString("TTTFilterText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.filterBoxPanel.addContent(this.filterTextTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("FileType"));
        jLabel.setToolTipText(Localizer.getString("TTTFileType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.filterBoxPanel.addContent(jLabel, gridBagConstraints);
        this.mediaTypeComboBox = new JComboBox<MediaType>(MediaType.getAllMediaTypes());
        this.mediaTypeComboBox.setRenderer(new MediaTypeListRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.filterBoxPanel.addContent(this.mediaTypeComboBox, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MinFileSize"));
        jLabel.setToolTipText(Localizer.getString("TTTMinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.filterBoxPanel.addContent(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.filterBoxPanel.addContent(jPanel, gridBagConstraints);
        this.minFileSizeTF = new IntegerTextField(9);
        this.minFileSizeTF.setToolTipText(Localizer.getString("TTTMinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.minFileSizeTF, gridBagConstraints);
        this.minFileSizeUnitComboBox = new JComboBox<SizeDefinition>(this.sizeDefinitions);
        this.minFileSizeUnitComboBox.setToolTipText(Localizer.getString("TTTMinFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.minFileSizeUnitComboBox, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxFileSize"));
        jLabel.setToolTipText(Localizer.getString("TTTMaxFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.filterBoxPanel.addContent(jLabel, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.filterBoxPanel.addContent(jPanel, gridBagConstraints);
        this.maxFileSizeTF = new IntegerTextField(9);
        this.maxFileSizeTF.setToolTipText(Localizer.getString("TTTMaxFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.maxFileSizeTF, gridBagConstraints);
        this.maxFileSizeUnitComboBox = new JComboBox<SizeDefinition>(this.sizeDefinitions);
        this.maxFileSizeUnitComboBox.setToolTipText(Localizer.getString("TTTMaxFileSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.maxFileSizeUnitComboBox, gridBagConstraints);
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        this.filterButton = new JButton(Localizer.getString("FilterResults"), GUIRegistry.getInstance().getIconFactory().getIcon("Filter"));
        this.filterButton.setToolTipText(Localizer.getString("TTTFilterResults"));
        this.filterButton.setCursor(Cursor.getPredefinedCursor(12));
        this.filterButton.setMargin(insets);
        this.filterButton.addActionListener(buttonActionHandler);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 12, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.filterBoxPanel.addContent(this.filterButton, gridBagConstraints);
        LinkLabel linkLabel3 = new LinkLabel(this.searchTab.getTabAction("RemoveFilterAction"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.filterBoxPanel.addContent(linkLabel3, gridBagConstraints);
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel != searchResultsDataModel) {
            if (this.displayedDataModel != null) {
                this.displayedDataModel.getSearch().removeSearchChangeListener(this);
            }
            this.displayedDataModel = searchResultsDataModel;
            if (this.displayedDataModel != null) {
                this.displayedDataModel.getSearch().addSearchChangeListener(this);
            }
            this.updateControlPanel();
        }
    }

    private void updateControlPanel() {
        if (this.displayedDataModel != null) {
            this.searchBoxPanel.setHeaderText(Localizer.getString("EditSearch"));
            Search search = this.displayedDataModel.getSearch();
            String string = search.getSearchString();
            this.searchTermComboBox.setSelectedItem(string);
            ((JTextField)this.searchTermComboBox.getEditor().getEditorComponent()).setText(string);
            if (search.isSearching()) {
                this.searchButton.setText(Localizer.getString("StopSearch"));
                this.searchButton.setToolTipText(Localizer.getString("TTTStopSearch"));
                this.searchTermComboBox.setEnabled(false);
            } else {
                this.searchButton.setText(Localizer.getString("StartSearch"));
                this.searchButton.setToolTipText(Localizer.getString("TTTStartSearch"));
                if (search instanceof BrowseHostResults) {
                    this.searchTermComboBox.setEnabled(false);
                } else {
                    this.searchTermComboBox.setEnabled(true);
                }
            }
            SearchFilter searchFilter = this.displayedDataModel.getSearchFilter();
            if (searchFilter != null) {
                long l;
                this.filterTextTF.setText(searchFilter.getFilterString());
                this.mediaTypeComboBox.setSelectedItem(searchFilter.getMediaType());
                long l2 = searchFilter.getMinFileSize();
                if (l2 > 0L) {
                    this.minFileSizeUnitComboBox.setSelectedIndex(0);
                    for (int i = this.sizeDefinitions.length - 1; i >= 0; --i) {
                        SizeDefinition sizeDefinition = this.sizeDefinitions[i];
                        long l3 = l2 % sizeDefinition.getMultiplier();
                        if (l3 != 0L) continue;
                        this.minFileSizeUnitComboBox.setSelectedIndex(i);
                        l2 /= sizeDefinition.getMultiplier();
                        break;
                    }
                    this.minFileSizeTF.setText(String.valueOf(l2));
                }
                if ((l = searchFilter.getMaxFileSize()) > 0L) {
                    this.maxFileSizeUnitComboBox.setSelectedIndex(0);
                    for (int i = this.sizeDefinitions.length - 1; i >= 0; --i) {
                        SizeDefinition sizeDefinition = this.sizeDefinitions[i];
                        long l4 = l % sizeDefinition.getMultiplier();
                        if (l4 != 0L) continue;
                        this.maxFileSizeUnitComboBox.setSelectedIndex(i);
                        l /= sizeDefinition.getMultiplier();
                        break;
                    }
                    this.maxFileSizeTF.setText(String.valueOf(l));
                }
            } else {
                this.filterTextTF.setText("");
                this.mediaTypeComboBox.setSelectedIndex(0);
                this.minFileSizeTF.setText("");
                this.maxFileSizeTF.setText("");
            }
        } else {
            this.searchBoxPanel.setHeaderText(Localizer.getString("Search"));
            this.searchTermComboBox.setSelectedItem(null);
            ((JTextField)this.searchTermComboBox.getEditor().getEditorComponent()).setText("");
            this.searchButton.setText(Localizer.getString("StartSearch"));
            this.searchButton.setToolTipText(Localizer.getString("TTTStartSearch"));
            this.searchTermComboBox.setEnabled(true);
            this.filterTextTF.setText("");
            this.mediaTypeComboBox.setSelectedIndex(0);
            this.minFileSizeTF.setText("");
            this.maxFileSizeTF.setText("");
        }
    }

    public void updateUI() {
        ListCellRenderer listCellRenderer;
        super.updateUI();
        Color color = UIManager.getColor("controlDkShadow");
        Color color2 = UIManager.getColor("window");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, color2), BorderFactory.createMatteBorder(1, 1, 1, 1, color)));
        this.setBackground(color2);
        GUIUtils.adjustComboBoxHeight(this.searchTermComboBox);
        GUIUtils.adjustComboBoxHeight(this.mediaTypeComboBox);
        GUIUtils.adjustComboBoxHeight(this.minFileSizeUnitComboBox);
        GUIUtils.adjustComboBoxHeight(this.maxFileSizeUnitComboBox);
        if (this.searchTermComboBox != null && (listCellRenderer = this.searchTermComboBox.getRenderer()) != null) {
            FontMetrics fontMetrics = this.searchTermComboBox.getFontMetrics(this.searchTermComboBox.getFont());
            int n = fontMetrics.getMaxAdvance() * 8;
            int n2 = fontMetrics.getMaxAdvance() * 6;
            Dimension dimension = this.searchTermComboBox.getMaximumSize();
            dimension.width = Math.max(n2, Math.min(n, dimension.width));
            this.searchTermComboBox.setMaximumSize(dimension);
            dimension = this.searchTermComboBox.getPreferredSize();
            dimension.width = Math.max(n2, Math.min(n, dimension.width));
            this.searchTermComboBox.setPreferredSize(dimension);
        }
    }

    public void searchChanged(SearchChangeEvent searchChangeEvent) {
        short s = searchChangeEvent.getType();
        switch (s) {
            case 0: 
            case 3: 
            case 4: {
                this.updateControlPanel();
            }
        }
    }

    private class SizeDefinition {
        private String representation;
        private long multiplier;

        public SizeDefinition(String string, long l) {
            this.representation = Localizer.getString(string);
            this.multiplier = l;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public String toString() {
            return this.representation;
        }
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchControlPanel.this.filterButton) {
                this.filterSearchResults();
            }
        }

        private void filterSearchResults() {
            long l;
            if (SearchControlPanel.this.displayedDataModel == null) {
                return;
            }
            String string = SearchControlPanel.this.filterTextTF.getText().trim();
            String string2 = SearchControlPanel.this.minFileSizeTF.getText().trim();
            String string3 = SearchControlPanel.this.maxFileSizeTF.getText().trim();
            MediaType mediaType = (MediaType)SearchControlPanel.this.mediaTypeComboBox.getSelectedItem();
            long l2 = -1L;
            try {
                if (string2.length() > 0) {
                    l = Integer.parseInt(string2);
                    SizeDefinition sizeDefinition = (SizeDefinition)SearchControlPanel.this.minFileSizeUnitComboBox.getSelectedItem();
                    long l3 = sizeDefinition.getMultiplier();
                    l2 = l3 * l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayWrongNumberFormatError(SearchControlPanel.this.minFileSizeTF);
                return;
            }
            l = -1L;
            try {
                if (string3.length() > 0) {
                    long l4 = Integer.parseInt(string3);
                    SizeDefinition sizeDefinition = (SizeDefinition)SearchControlPanel.this.maxFileSizeUnitComboBox.getSelectedItem();
                    long l5 = sizeDefinition.getMultiplier();
                    l = l5 * l4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.displayWrongNumberFormatError(SearchControlPanel.this.maxFileSizeTF);
                return;
            }
            SearchFilter searchFilter = SearchControlPanel.this.displayedDataModel.getSearchFilter();
            if (searchFilter == null) {
                searchFilter = new SearchFilter();
            }
            searchFilter.updateSearchFilter(string, mediaType, l2, l);
            SearchControlPanel.this.displayedDataModel.updateSearchFilter(searchFilter);
            SearchControlPanel.this.searchTab.getTabAction("RemoveFilterAction").refreshActionState();
        }

        private void displayWrongNumberFormatError(JTextField jTextField) {
            jTextField.requestFocus();
            jTextField.selectAll();
            JOptionPane.showMessageDialog(SearchControlPanel.this.searchTab, Localizer.getString("WrongNumberFormat"), Localizer.getString("FormatError"), 0);
        }
    }

    private class SubmitSearchHandler
    extends AbstractAction
    implements ActionListener {
        private SubmitSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchControlPanel.this.displayedDataModel != null && SearchControlPanel.this.displayedDataModel.getSearch().isSearching()) {
                SearchControlPanel.this.displayedDataModel.getSearch().stopSearching();
                return;
            }
            String string = (String)SearchControlPanel.this.searchTermComboBox.getEditor().getItem();
            SearchControlPanel.this.searchComboModel.setSelectedItem(string);
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            if (string.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
                Object[] objectArray = new Object[]{new Integer(Cfg.MIN_SEARCH_TERM_LENGTH)};
                GUIUtils.showErrorMessage(Localizer.getFormatedString("MinSearchTerm", objectArray));
                SearchControlPanel.this.searchTermComboBox.getEditor().selectAll();
                try {
                    ((JComponent)SearchControlPanel.this.searchTermComboBox.getEditor().getEditorComponent()).requestFocus();
                }
                catch (Exception exception) {
                    Logger.logError(exception, SearchControlPanel.this.searchTermComboBox.getEditor().toString());
                }
                return;
            }
            Search search = SearchControlPanel.this.searchContainer.getRunningSearch(string);
            if (search != null) {
                SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchControlPanel.this.searchTab.setDisplayedSearch(searchResultsDataModel);
                return;
            }
            if (SearchControlPanel.this.displayedDataModel == null) {
                Search search2 = SearchControlPanel.this.searchContainer.createSearch(string);
                SearchResultsDataModel searchResultsDataModel = SearchResultsDataModel.registerNewSearch(search2);
                SearchControlPanel.this.searchTab.setDisplayedSearch(searchResultsDataModel);
            } else {
                SearchControlPanel.this.displayedDataModel.getSearch().setSearchString(string);
                SearchControlPanel.this.displayedDataModel.getSearch().startSearching();
            }
            int n = SearchControlPanel.this.searchComboModel.getIndexOf(string);
            if (n < 0) {
                SearchControlPanel.this.searchComboModel.insertElementAt(string, 0);
                if (SearchControlPanel.this.searchComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    SearchControlPanel.this.searchComboModel.removeElementAt(SearchControlPanel.this.searchComboModel.getSize() - 1);
                }
                this.saveSearchList();
            } else if (n > 0) {
                SearchControlPanel.this.searchComboModel.removeElementAt(n);
                SearchControlPanel.this.searchComboModel.insertElementAt(string, 0);
                this.saveSearchList();
            }
        }

        private void saveSearchList() {
            int n = SearchControlPanel.this.searchComboModel.getSize();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(SearchControlPanel.this.searchComboModel.getElementAt(i));
            }
            ServiceManager.sCfg.searchTermHistory.clear();
            ServiceManager.sCfg.searchTermHistory.addAll(arrayList);
            ServiceManager.sCfg.save();
        }
    }
}

