/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.xml.bind.JAXBException;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.search.SearchControlPanel;
import phex.gui.tabs.search.SearchListPanel;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchResultsPanel;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.query.SearchFilter;
import phex.utils.Localizer;
import phex.xml.XJBGUISettings;

public class SearchTab
extends FWTab {
    private SearchResultsDataModel displayedDataModel;
    private SearchListPanel searchListPanel;
    private SearchControlPanel searchControlPanel;
    private SearchResultsPanel searchResultPanel;
    public static final String CLEAR_SEARCH_RESULTS_ACTION = "ClearSearchResultsAction";
    public static final String CREATE_NEW_SEARCH_ACTION = "CreateNewSearchAction";
    public static final String CLOSE_SEARCH_ACTION = "CloseSearchAction";
    public static final String REMOVE_FILTER_ACTION = "RemoveFilterAction";

    public SearchTab() {
        super(1101, Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTSearchTab"), Localizer.getChar("SearchMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("SearchAccelerator")), 1);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        this.addTabAction(CLEAR_SEARCH_RESULTS_ACTION, new ClearSearchResultsAction());
        this.addTabAction(CREATE_NEW_SEARCH_ACTION, new CreateNewSearchAction());
        this.addTabAction(REMOVE_FILTER_ACTION, new RemoveFilterAction());
        this.addTabAction(CLOSE_SEARCH_ACTION, new CloseSearchAction());
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout = new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, p, 1dlu, fill:d:grow, 3dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.addSeparator(Localizer.getString("Search"), cellConstraints.xy(2, 2));
        this.searchListPanel = new SearchListPanel(this);
        this.searchListPanel.initializeComponent(xJBGUISettings);
        JPanel jPanel = new JPanel();
        FormLayout formLayout2 = new FormLayout("d, 1dlu, fill:d:grow", "fill:d:grow");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        this.searchControlPanel = new SearchControlPanel(this);
        panelBuilder2.add((Component)this.searchControlPanel, cellConstraints.xy(1, 1));
        this.searchResultPanel = new SearchResultsPanel(this);
        this.searchResultPanel.initializeComponent(xJBGUISettings);
        panelBuilder2.add((Component)this.searchResultPanel, cellConstraints.xy(3, 1));
        Dimension dimension = new Dimension(400, 300);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(new Dimension(0, 0));
        this.searchListPanel.setMinimumSize(new Dimension(0, 0));
        JSplitPane jSplitPane = new JSplitPane(0, this.searchListPanel, jPanel);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        panelBuilder.add((Component)jSplitPane, cellConstraints.xy(2, 4));
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel == searchResultsDataModel) {
            return;
        }
        this.displayedDataModel = searchResultsDataModel;
        this.searchResultPanel.setDisplayedSearch(this.displayedDataModel);
        this.searchListPanel.setDisplayedSearch(this.displayedDataModel);
        this.searchControlPanel.setDisplayedSearch(this.displayedDataModel);
        this.refreshTabActions();
    }

    public void clearSearchHistory() {
        this.searchControlPanel.clearSearchHistory();
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        this.searchListPanel.appendXJBGUISettings(xJBGUISettings);
        this.searchResultPanel.appendXJBGUISettings(xJBGUISettings);
    }

    private class CreateNewSearchAction
    extends FWAction {
        public CreateNewSearchAction() {
            super(Localizer.getString("CreateNewSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTCreateNewSearch"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchTab.this.setDisplayedSearch(null);
        }

        public void refreshActionState() {
            this.setEnabled(true);
        }
    }

    private class RemoveFilterAction
    extends FWAction {
        public RemoveFilterAction() {
            super(Localizer.getString("RemoveSearchFilter"), (Icon)IconFactory.EMPTY_IMAGE_16, Localizer.getString("TTTRemoveSearchFilter"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchTab.this.displayedDataModel != null) {
                SearchTab.this.displayedDataModel.clearSearchFilter();
                SearchTab.this.refreshTabActions();
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.displayedDataModel == null) {
                this.setEnabled(false);
            } else {
                SearchFilter searchFilter = SearchTab.this.displayedDataModel.getSearchFilter();
                this.setEnabled(searchFilter != null);
            }
        }
    }

    private class ClearSearchResultsAction
    extends FWAction {
        public ClearSearchResultsAction() {
            super(Localizer.getString("ClearSearchResults"), GUIRegistry.getInstance().getIconFactory().getIcon("Remove"), Localizer.getString("TTTClearSearchResults"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchTab.this.displayedDataModel != null) {
                SearchTab.this.displayedDataModel.clearSearchResults();
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.displayedDataModel == null || SearchTab.this.displayedDataModel.getSearchElementCount() + SearchTab.this.displayedDataModel.getFilteredElementCount() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class CloseSearchAction
    extends FWAction {
        private SearchContainer searchContainer;

        public CloseSearchAction() {
            super(Localizer.getString("CloseSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTCloseSearch"));
            this.searchContainer = QueryManager.getInstance().getSearchContainer();
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SearchTab.this.displayedDataModel != null) {
                this.searchContainer.removeSearch(SearchTab.this.displayedDataModel.getSearch());
                SearchTab.this.setDisplayedSearch(null);
            }
        }

        public void refreshActionState() {
            if (SearchTab.this.displayedDataModel == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

