/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import phex.connection.ProtocolNotSupportedException;

public class GWebCache {
    private URL url;
    private boolean isPhexCache;
    private int hash = 0;

    public GWebCache(URL uRL) throws IOException {
        this(uRL, false);
    }

    public GWebCache(URL uRL, boolean bl) throws IOException {
        if (uRL == null) {
            throw new NullPointerException("Null url given.");
        }
        if (!uRL.getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        if (uRL.getPort() == 80) {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), -1, uRL.getFile());
        }
        this.url = uRL;
        this.isPhexCache = bl;
    }

    public boolean isPhexCache() {
        return this.isPhexCache;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GWebCache)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GWebCache gWebCache = (GWebCache)object;
        return new EqualsBuilder().append(this.url.toExternalForm(), gWebCache.url.toExternalForm()).isEquals();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = new HashCodeBuilder(17, 37).append(this.url.toExternalForm()).toHashCode();
        }
        return this.hash;
    }
}

