/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import phex.common.Environment;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCache;
import phex.host.HostAddress;
import phex.security.PhexSecurityManager;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;
import phex.utils.VersionUtils;

public class GWebCacheConnection {
    private static final String PING_QUERY = "ping=1";
    private static final String HOST_FILE_QUERY = "hostfile=1";
    private static final String URL_FILE_QUERY = "urlfile=1";
    private static final String IP_QUERY = "ip=";
    private static final String URL_QUERY = "url=";
    private static final String QUERY_POSTFIX = "&client=PHEX&version=" + VersionUtils.getFullProgramVersion();
    private GWebCache gWebCache;
    private HttpURLConnection connection;
    private BufferedReader reader;
    boolean isCacheBad;

    public GWebCacheConnection(GWebCache gWebCache) throws ProtocolNotSupportedException {
        if (!gWebCache.getUrl().getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        this.gWebCache = gWebCache;
        this.isCacheBad = false;
    }

    public GWebCache getGWebCache() {
        return this.gWebCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPingRequest() {
        try {
            URL uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + PING_QUERY + QUERY_POSTFIX);
            if (uRL.getHost() == null) {
                NLogger.warn("GWEBCACHE", "Host is null");
                this.isCacheBad = true;
                boolean bl = false;
                return bl;
            }
            this.openConnection(uRL);
            String string = this.reader.readLine();
            if (string != null && string.startsWith("PONG")) {
                boolean bl = true;
                return bl;
            }
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage(Logger.FINEST, (short)16, unknownHostException);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAddress[] sendHostFileRequest() {
        String string;
        try {
            Object[] objectArray;
            URL uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + HOST_FILE_QUERY + QUERY_POSTFIX);
            if (uRL.getHost() == null) {
                NLogger.warn("GWEBCACHE", "Host is null");
                this.isCacheBad = true;
                HostAddress[] hostAddressArray = null;
                return hostAddressArray;
            }
            this.openConnection(uRL);
            string = this.reader.readLine();
            if (string != null && string.startsWith("ERROR")) {
                this.isCacheBad = true;
                HostAddress[] hostAddressArray = null;
                return hostAddressArray;
            }
            boolean bl = false;
            ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>(20);
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            block11: while (string != null) {
                objectArray = HostAddress.parseIP(string);
                if (objectArray == null) {
                    string = this.reader.readLine();
                    bl = true;
                    continue;
                }
                byte by = phexSecurityManager.controlHostIPAccess((byte[])objectArray);
                switch (by) {
                    case 2: 
                    case 3: {
                        string = this.reader.readLine();
                        continue block11;
                    }
                }
                int n = HostAddress.parsePort(string);
                if (n != -1) {
                    HostAddress hostAddress = new HostAddress((byte[])objectArray, n);
                    arrayList.add(hostAddress);
                } else {
                    bl = true;
                }
                string = this.reader.readLine();
            }
            if (arrayList.size() == 0 && bl) {
                this.isCacheBad = true;
                objectArray = null;
                return objectArray;
            }
            objectArray = new HostAddress[arrayList.size()];
            arrayList.toArray(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            string = null;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] sendURLFileRequest() {
        String string;
        try {
            URL[] uRLArray;
            URL uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + URL_FILE_QUERY + QUERY_POSTFIX);
            if (uRL.getHost() == null) {
                NLogger.warn("GWEBCACHE", "Host is null");
                this.isCacheBad = true;
                URL[] uRLArray2 = null;
                return uRLArray2;
            }
            this.openConnection(uRL);
            string = this.reader.readLine();
            if (string != null && string.startsWith("ERROR")) {
                this.isCacheBad = true;
                URL[] uRLArray3 = null;
                return uRLArray3;
            }
            boolean bl = false;
            ArrayList<URL[]> arrayList = new ArrayList<URL[]>(20);
            while (string != null) {
                try {
                    uRLArray = new URL(string);
                    if (!uRLArray.getProtocol().equals("http")) {
                        throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
                    }
                    arrayList.add(uRLArray);
                }
                catch (MalformedURLException malformedURLException) {
                    bl = true;
                }
                string = this.reader.readLine();
            }
            if (arrayList.size() == 0 && bl) {
                this.isCacheBad = true;
                uRLArray = null;
                return uRLArray;
            }
            uRLArray = new URL[arrayList.size()];
            arrayList.toArray(uRLArray);
            URL[] uRLArray4 = uRLArray;
            return uRLArray4;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            string = null;
            return string;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRequest(String string, String string2) {
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Must provide at least one of hostIP or cacheURL.");
        }
        try {
            URL uRL;
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(IP_QUERY);
                stringBuffer.append(URLCodecUtils.encodeURL(string));
            }
            if (string2 != null) {
                if (string != null) {
                    stringBuffer.append('&');
                }
                stringBuffer.append(URL_QUERY);
                stringBuffer.append(URLCodecUtils.encodeURL(string2));
            }
            if ((uRL = new URL(this.gWebCache.getUrl(), this.gWebCache.getUrl().getPath() + '?' + stringBuffer.toString() + QUERY_POSTFIX)).getHost() == null) {
                NLogger.warn("GWEBCACHE", "Host is null");
                this.isCacheBad = true;
                boolean bl = false;
                return bl;
            }
            this.openConnection(uRL);
            String string3 = this.reader.readLine();
            if (string3 != null && string3.startsWith("OK")) {
                boolean bl = true;
                return bl;
            }
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean isCacheBad() {
        return this.isCacheBad;
    }

    private void openConnection(URL uRL) throws IOException {
        this.connection = (HttpURLConnection)uRL.openConnection();
        this.connection.setUseCaches(false);
        this.connection.setInstanceFollowRedirects(false);
        this.connection.setRequestProperty("Cache-Control", "no-cache");
        this.connection.setRequestProperty("User-Agent", Environment.getPhexVendor());
        this.connection.setRequestProperty("Connection", "close");
        NLogger.debug("GWEBCACHE", "Open GWebCache connection to " + uRL + ".");
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConnectException("GWebCache service not available, FileNotFound.");
        }
        int n = this.connection.getResponseCode();
        NLogger.debug("GWEBCACHE", "GWebCache " + uRL + " returned response code: " + n);
        if (n < 200 && n > 299) {
            throw new ConnectException("GWebCache service not available, response code: " + n);
        }
    }

    private void closeConnection() {
        IOUtil.closeQuietly(this.reader);
        this.reader = null;
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }
}

