/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import phex.common.GeneralGnutellaNetwork;
import phex.connection.NetworkManager;
import phex.connection.ProtocolNotSupportedException;
import phex.gwebcache.GWebCache;
import phex.gwebcache.GWebCacheConnection;
import phex.host.CaughtHostsContainer;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.utils.Logger;
import phex.utils.NLogger;

public class GWebCacheContainer {
    private static int MIN_G_WEB_CACHES_SIZE = 20;
    private ArrayList allGWebCaches;
    private ArrayList functionalGWebCaches;
    private HashSet uniqueGWebCaches;
    private Random random;

    public GWebCacheContainer() {
        Logger.logMessage(Logger.FINEST, (short)255, "Initializing GWebCacheContainer");
        this.allGWebCaches = new ArrayList();
        this.functionalGWebCaches = new ArrayList();
        this.uniqueGWebCaches = new HashSet();
        this.random = new Random();
        Logger.logMessage(Logger.FINEST, (short)255, "Initialized GWebCacheContainer");
    }

    public void initializeGWebCacheContainer() {
        this.allGWebCaches.clear();
        this.functionalGWebCaches.clear();
        this.uniqueGWebCaches.clear();
        this.insertPhexGWebCaches();
        this.loadGWebCacheFromFile();
    }

    public boolean queryMoreHosts() {
        int n = 0;
        boolean bl = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection();
            if (gWebCacheConnection == null) continue;
            HostAddress[] hostAddressArray = gWebCacheConnection.sendHostFileRequest();
            if (!this.verifyGWebCache(gWebCacheConnection) || hostAddressArray == null) continue;
            CaughtHostsContainer caughtHostsContainer = HostManager.getInstance().getCaughtHostsContainer();
            for (int i = 0; i < hostAddressArray.length; ++i) {
                caughtHostsContainer.addCaughtHost(hostAddressArray[i], (short)2);
            }
            bl = true;
        } while (!bl && n < 5);
        return bl;
    }

    public boolean updateRemoteGWebCache(HostAddress hostAddress) {
        String string = null;
        if (hostAddress != null) {
            string = hostAddress.getFullHostName();
        }
        int n = 0;
        boolean bl = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection();
            if (gWebCacheConnection == null) continue;
            GWebCache gWebCache = this.getRandomFunctionalGWebCache();
            if (gWebCache != null && !gWebCache.isPhexCache() && gWebCache.equals(gWebCacheConnection.getGWebCache()) && (gWebCache = this.getRandomFunctionalGWebCache()) != null && !gWebCache.isPhexCache() && gWebCache.equals(gWebCacheConnection.getGWebCache())) {
                gWebCache = null;
            }
            String string2 = null;
            if (gWebCache != null) {
                string2 = gWebCache.getUrl().toExternalForm();
            }
            if (string == null && string2 == null) continue;
            bl = gWebCacheConnection.updateRequest(string, string2);
            if (this.verifyGWebCache(gWebCacheConnection) && bl) continue;
        } while (!bl && n < 5);
        return bl;
    }

    public boolean queryMoreGWebCaches() {
        int n = 0;
        boolean bl = false;
        do {
            ++n;
            GWebCacheConnection gWebCacheConnection = this.getRandomGWebCacheConnection();
            if (gWebCacheConnection == null) continue;
            URL[] uRLArray = gWebCacheConnection.sendURLFileRequest();
            if (!this.verifyGWebCache(gWebCacheConnection) || uRLArray == null) continue;
            for (int i = 0; i < uRLArray.length; ++i) {
                try {
                    this.insertGWebCache(new GWebCache(uRLArray[i]));
                    continue;
                }
                catch (IOException iOException) {
                    NLogger.debug("GWEBCACHE", iOException);
                }
            }
            if (uRLArray.length > 0) {
                this.saveGWebCacheToFile();
            }
            bl = true;
        } while (!bl && n < 5);
        return bl;
    }

    public int getGWebCacheCount() {
        return this.allGWebCaches.size();
    }

    private GWebCache getRandomFunctionalGWebCache() {
        GWebCache gWebCache = null;
        int n = this.functionalGWebCaches.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (GWebCache)this.functionalGWebCaches.get(0);
        }
        int n2 = this.random.nextInt(n - 1);
        gWebCache = (GWebCache)this.functionalGWebCaches.get(n2);
        return gWebCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GWebCache getRandomGWebCache() {
        GWebCache gWebCache = null;
        this.ensureMinGWebCaches();
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            int n = this.allGWebCaches.size();
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return (GWebCache)this.allGWebCaches.get(0);
            }
            int n2 = this.random.nextInt(n - 1);
            gWebCache = (GWebCache)this.allGWebCaches.get(n2);
        }
        return gWebCache;
    }

    private GWebCacheConnection getRandomGWebCacheConnection() {
        GWebCacheConnection gWebCacheConnection = null;
        GWebCache gWebCache = null;
        try {
            gWebCache = this.getRandomGWebCache();
            if (gWebCache == null) {
                return null;
            }
            gWebCacheConnection = new GWebCacheConnection(gWebCache);
        }
        catch (ProtocolNotSupportedException protocolNotSupportedException) {
            this.removeGWebCache(gWebCache, true);
            return null;
        }
        if (!this.functionalGWebCaches.contains(gWebCache)) {
            this.functionalGWebCaches.add(gWebCache);
        }
        return gWebCacheConnection;
    }

    private boolean verifyGWebCache(GWebCacheConnection gWebCacheConnection) {
        if (gWebCacheConnection.isCacheBad()) {
            this.removeGWebCache(gWebCacheConnection.getGWebCache(), false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGWebCache(GWebCache gWebCache) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (!this.uniqueGWebCaches.contains(gWebCache)) {
                this.allGWebCaches.add(gWebCache);
                this.uniqueGWebCaches.add(gWebCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGWebCache(GWebCache gWebCache, boolean bl) {
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            if (this.allGWebCaches.size() > MIN_G_WEB_CACHES_SIZE || bl) {
                this.allGWebCaches.remove(gWebCache);
                this.functionalGWebCaches.remove(gWebCache);
                this.uniqueGWebCaches.remove(gWebCache);
                this.saveGWebCacheToFile();
            }
        }
    }

    private void insertGWebCache(String string) {
        try {
            URL uRL = new URL(string);
            this.insertGWebCache(new GWebCache(uRL));
        }
        catch (IOException iOException) {
            NLogger.debug("GWEBCACHE", iOException);
        }
    }

    private void ensureMinGWebCaches() {
        if (this.allGWebCaches.size() >= 10) {
            return;
        }
        NetworkManager networkManager = NetworkManager.getInstance();
        if (!(networkManager.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)16, "Load default GWebCache file.");
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/gwebcache.cfg");
        if (inputStream != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            try {
                this.loadGWebCacheFromReader(inputStreamReader);
                this.saveGWebCacheToFile();
            }
            catch (IOException iOException) {
                Logger.logWarning(iOException);
            }
        } else {
            Logger.logMessage(Logger.FINE, (short)16, "Default GWebCache file not found.");
        }
        if (this.allGWebCaches.size() < 1) {
            this.insertPhexGWebCaches();
            this.saveGWebCacheToFile();
        }
    }

    private void insertPhexGWebCaches() {
        NetworkManager networkManager = NetworkManager.getInstance();
        if (!(networkManager.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        try {
            URL uRL = new URL("http://gc-phex01.draketo.de/gcache.php");
            GWebCache gWebCache = new GWebCache(uRL, true);
            this.insertGWebCache(gWebCache);
            uRL = new URL("http://phex.kouk.de/gwebcache/gcache.php");
            gWebCache = new GWebCache(uRL, true);
            this.insertGWebCache(gWebCache);
        }
        catch (IOException iOException) {
            NLogger.error("GWEBCACHE", iOException, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromFile() {
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getGWebCacheFile();
            if (!file.exists()) {
                return;
            }
            this.loadGWebCacheFromReader(new FileReader(file));
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
        finally {
            this.ensureMinGWebCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromReader(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList arrayList = this.allGWebCaches;
        synchronized (arrayList) {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                this.insertGWebCache(string);
            }
        }
        bufferedReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGWebCacheToFile() {
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getGWebCacheFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            ArrayList arrayList = this.allGWebCaches;
            synchronized (arrayList) {
                Iterator iterator = this.allGWebCaches.iterator();
                while (iterator.hasNext()) {
                    GWebCache gWebCache = (GWebCache)iterator.next();
                    if (gWebCache.isPhexCache()) continue;
                    bufferedWriter.write(gWebCache.getUrl().toExternalForm());
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
    }
}

