/*
 * Decompiled with CFR 0.152.
 */
package phex.gwebcache;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.Manager;
import phex.common.ThreadPool;
import phex.connection.NetworkManager;
import phex.gwebcache.GWebCacheContainer;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.Logger;

public class GWebCacheManager
implements Manager {
    private static GWebCacheManager instance;
    private GWebCacheContainer gWebCacheContainer;
    private boolean isThreadRequestRunning = false;

    public GWebCacheContainer getGWebCacheContainer() {
        return this.gWebCacheContainer;
    }

    public synchronized void invokeQueryMoreHostsRequest() {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryHostsRunner queryHostsRunner = new QueryHostsRunner();
        ThreadPool.getInstance().addJob(queryHostsRunner, "GWebCacheQuery-" + Integer.toHexString(queryHostsRunner.hashCode()));
    }

    public void invokeUpdateRemoteGWebCache(HostAddress hostAddress) {
        UpdateGWebCacheRunner updateGWebCacheRunner = new UpdateGWebCacheRunner(hostAddress);
        ThreadPool.getInstance().addJob(updateGWebCacheRunner, "GWebCacheQuery-" + Integer.toHexString(updateGWebCacheRunner.hashCode()));
    }

    public synchronized void invokeQueryMoreGWebCachesRequest() {
        if (this.isThreadRequestRunning) {
            return;
        }
        this.isThreadRequestRunning = true;
        QueryGWebCachesRunner queryGWebCachesRunner = new QueryGWebCachesRunner();
        ThreadPool.getInstance().addJob(queryGWebCachesRunner, "GWebCacheQuery-" + Integer.toHexString(queryGWebCachesRunner.hashCode()));
    }

    public static GWebCacheManager getInstance() {
        if (instance == null) {
            instance = new GWebCacheManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.gWebCacheContainer = new GWebCacheContainer();
        return true;
    }

    public boolean onPostInitialization() {
        Environment.getInstance().scheduleTimerTask(new QueryGWebCacheTimer(), 0L, 600000L);
        Environment.getInstance().scheduleTimerTask(new UpdateGWebCacheTimer(), 3600000L, 3600000L);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    private final class UpdateGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 3600000L;

        private UpdateGWebCacheTimer() {
        }

        public void run() {
            NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
            NetworkManager networkManager = NetworkManager.getInstance();
            if (networkManager.isConnected() || networkHostsContainer.getTotalConnectionCount() > 0) {
                HostAddress hostAddress = null;
                if (networkManager.hasConnectedIncoming() && (hostAddress = networkManager.getLocalAddress()).isPrivateIP()) {
                    hostAddress = null;
                }
                GWebCacheManager.this.invokeUpdateRemoteGWebCache(hostAddress);
            }
        }
    }

    private final class QueryGWebCacheTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 600000L;

        private QueryGWebCacheTimer() {
        }

        public void run() {
            try {
                NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
                if (NetworkManager.getInstance().isConnected() || networkHostsContainer.getTotalConnectionCount() > 0) {
                    GWebCacheManager.this.invokeQueryMoreGWebCachesRequest();
                    GWebCacheManager.this.invokeQueryMoreHostsRequest();
                }
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }

    private final class QueryHostsRunner
    implements Runnable {
        private QueryHostsRunner() {
        }

        public void run() {
            GWebCacheManager.this.gWebCacheContainer.queryMoreHosts();
            GWebCacheManager.this.isThreadRequestRunning = false;
        }
    }

    private final class UpdateGWebCacheRunner
    implements Runnable {
        private final HostAddress myHostAddress;

        private UpdateGWebCacheRunner(HostAddress hostAddress) {
            this.myHostAddress = hostAddress;
        }

        public void run() {
            GWebCacheManager.this.gWebCacheContainer.updateRemoteGWebCache(this.myHostAddress);
        }
    }

    private final class QueryGWebCachesRunner
    implements Runnable {
        private QueryGWebCachesRunner() {
        }

        public void run() {
            GWebCacheManager.this.gWebCacheContainer.queryMoreGWebCaches();
            GWebCacheManager.this.isThreadRequestRunning = false;
        }
    }
}

