/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import phex.common.IntObj;
import phex.host.HostAddress;

public class CaughtHost {
    private static IntObj CAUGHT_HOST_COUNTER = new IntObj(0);
    private int counter;
    private long lastFailedConnection;
    private long lastSuccessfulConnection;
    private int avgDailyUptime;
    private HostAddress hostAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaughtHost(HostAddress hostAddress) {
        IntObj intObj = CAUGHT_HOST_COUNTER;
        synchronized (intObj) {
            this.counter = CAUGHT_HOST_COUNTER.inc(1);
        }
        this.hostAddress = hostAddress;
        this.lastFailedConnection = -1L;
        this.lastSuccessfulConnection = -1L;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setDailyUptime(int n) {
        this.avgDailyUptime = n;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CaughtHost)) {
            return false;
        }
        return this.hostAddress.equals(((CaughtHost)object).hostAddress);
    }

    public int hashCode() {
        return this.hostAddress.hashCode();
    }

    public int getConnectionTimeRating() {
        if (this.lastSuccessfulConnection == -1L && this.lastFailedConnection == -1L) {
            return 0;
        }
        if (this.lastFailedConnection > this.lastSuccessfulConnection) {
            return -1;
        }
        return 1;
    }

    public void setLastFailedConnection(long l) {
        this.lastFailedConnection = l;
    }

    public void setLastSuccessfulConnection(long l) {
        this.lastSuccessfulConnection = l;
    }

    public long getLastFailedConnection() {
        return this.lastFailedConnection;
    }

    public long getLastSuccessfulConnection() {
        return this.lastSuccessfulConnection;
    }

    public String toString() {
        return "CaughtHost[" + this.hostAddress.toString() + ",Failed=" + this.lastFailedConnection + ",Successful=" + this.lastSuccessfulConnection + ",Uptime=" + this.avgDailyUptime + "]";
    }

    public int getCounter() {
        return this.counter;
    }
}

