/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.GeneralGnutellaNetwork;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.NetworkManager;
import phex.event.AsynchronousDispatcher;
import phex.event.CaughtHostsChangeListener;
import phex.gwebcache.GWebCacheManager;
import phex.host.CatchedHostCache;
import phex.host.CaughtHost;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.msg.MsgPong;
import phex.security.PhexSecurityManager;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.PriorityQueue;

public class CaughtHostsContainer {
    public static final short HIGH_PRIORITY = 2;
    public static final short NORMAL_PRIORITY = 1;
    public static final short LOW_PRIORITY = 0;
    private static final HostAddress[] DEFAULT_STARTUP_HOSTS = new HostAddress[]{new HostAddress("connect1.gnutellanet.com", 6346), new HostAddress("connect2.gnutellanet.com", 6346), new HostAddress("connect3.gnutellanet.com", 6346), new HostAddress("connect4.gnutellanet.com", 6346), new HostAddress("connect1.bearshare.net", 6346), new HostAddress("connect2.bearshare.net", 6346), new HostAddress("connect3.bearshare.net", 6346)};
    private PriorityQueue caughtHosts;
    private HashSet uniqueCaughtHosts;
    private CatchedHostCache catchedHostCache;
    private ArrayList listenerList = new ArrayList(2);
    private boolean hasChangedSinceLastSave;
    private ArrayList autoConnectHosts;

    public CaughtHostsContainer() {
        int[] nArray = new int[3];
        nArray[2] = (int)Math.round((double)ServiceManager.sCfg.mNetMaxHostToCatch * 2.0 / 3.0);
        nArray[1] = (int)Math.round((double)(ServiceManager.sCfg.mNetMaxHostToCatch - nArray[2]) * 2.0 / 3.0);
        nArray[0] = ServiceManager.sCfg.mNetMaxHostToCatch - nArray[2] - nArray[1];
        this.caughtHosts = new PriorityQueue(nArray);
        this.uniqueCaughtHosts = new HashSet();
        this.catchedHostCache = new CatchedHostCache();
        this.autoConnectHosts = new ArrayList();
        Environment.getInstance().scheduleTimerTask(new SaveHostsContainerTimer(), 60000L, 60000L);
    }

    public void initializeCaughtHostsContainer() {
        this.caughtHosts.clear();
        this.catchedHostCache.clear();
        this.removeAllAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
        this.loadHostsFromFile();
        this.loadAutoConnectHostsFromFile();
    }

    public synchronized void addCaughtHost(MsgPong msgPong) {
        int n;
        byte[] byArray = msgPong.getIP();
        HostAddress hostAddress = new HostAddress(byArray, n = msgPong.getPort());
        boolean bl = this.isValidCaughtHostAddress(hostAddress);
        if (!bl) {
            return;
        }
        CaughtHost caughtHost = new CaughtHost(hostAddress);
        int n2 = msgPong.getDailyUptime();
        if (n2 > 0) {
            caughtHost.setDailyUptime(n2);
        }
        short s = msgPong.isUltrapeerMarked() ? (short)2 : 0;
        this.addPersistentCaughtHost(caughtHost);
        this.addToCaughtHostFetcher(caughtHost, s);
    }

    public synchronized void addCaughtHost(HostAddress hostAddress, short s) {
        boolean bl = this.isValidCaughtHostAddress(hostAddress);
        if (!bl) {
            return;
        }
        CaughtHost caughtHost = new CaughtHost(hostAddress);
        this.addPersistentCaughtHost(caughtHost);
        this.addToCaughtHostFetcher(caughtHost, s);
    }

    private synchronized void addToCaughtHostFetcher(CaughtHost caughtHost, short s) {
        if (!this.uniqueCaughtHosts.contains(caughtHost)) {
            this.uniqueCaughtHosts.add(caughtHost);
            Object object = this.caughtHosts.addToHead(caughtHost, s);
            if (object != null) {
                this.uniqueCaughtHosts.remove(object);
            }
            this.fireCaughtHostsChanged();
        }
    }

    private synchronized void addPersistentCaughtHost(CaughtHost caughtHost) {
        HostAddress hostAddress = caughtHost.getHostAddress();
        CaughtHost caughtHost2 = this.catchedHostCache.getCaughHost(hostAddress);
        if (caughtHost2 == null) {
            this.catchedHostCache.add(caughtHost);
        } else {
            this.catchedHostCache.remove(caughtHost2);
            if (caughtHost.getDailyUptime() > 0) {
                caughtHost2.setDailyUptime(caughtHost.getDailyUptime());
            }
            this.catchedHostCache.add(caughtHost2);
        }
        this.hasChangedSinceLastSave = true;
    }

    public synchronized int getCaughtHostsCount() {
        return this.caughtHosts.getSize();
    }

    public synchronized HostAddress getNextCaughtHost() {
        this.ensureMinCaughHosts();
        if (!this.caughtHosts.isEmpty()) {
            CaughtHost caughtHost = (CaughtHost)this.caughtHosts.removeMaxPriority();
            return caughtHost.getHostAddress();
        }
        this.addAutoConnectHosts();
        if (!this.caughtHosts.isEmpty()) {
            CaughtHost caughtHost = (CaughtHost)this.caughtHosts.removeMaxPriority();
            return caughtHost.getHostAddress();
        }
        return null;
    }

    public synchronized void reportConnectionStatus(HostAddress hostAddress, boolean bl) {
        boolean bl2 = this.isValidCaughtHostAddress(hostAddress);
        if (!bl2) {
            return;
        }
        CaughtHost caughtHost = this.catchedHostCache.getCaughHost(hostAddress);
        if (caughtHost == null) {
            caughtHost = new CaughtHost(hostAddress);
        } else {
            this.catchedHostCache.remove(caughtHost);
        }
        if (bl) {
            caughtHost.setLastSuccessfulConnection(System.currentTimeMillis());
        } else {
            caughtHost.setLastFailedConnection(System.currentTimeMillis());
        }
        this.catchedHostCache.add(caughtHost);
        this.hasChangedSinceLastSave = true;
    }

    private void ensureMinCaughHosts() {
        int n = (int)Math.ceil((double)ServiceManager.sCfg.mNetMaxHostToCatch / 100.0);
        if (this.caughtHosts.getSize() < n) {
            GWebCacheManager.getInstance().invokeQueryMoreHostsRequest();
        }
    }

    private boolean isValidCaughtHostAddress(HostAddress hostAddress) {
        if (hostAddress.getPort() == -1 || hostAddress.isLocalHost() || !hostAddress.isValidIP() || hostAddress.isPrivateIP()) {
            return false;
        }
        return !IPUtils.isPortInUserInvalidList(hostAddress);
    }

    private void loadHostsFromFile() {
        Logger.logMessage(Logger.FINE, (short)16, "Loading hosts file.");
        try {
            String string;
            Object object;
            BufferedReader bufferedReader;
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getHostsFile();
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
            } else {
                Logger.logMessage(Logger.FINE, (short)16, "Load default hosts file.");
                object = ClassLoader.getSystemResourceAsStream("phex/resources/phex.hosts");
                if (object != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                } else {
                    Logger.logMessage(Logger.FINE, (short)16, "Default Phex Hosts file not found.");
                    return;
                }
            }
            object = PhexSecurityManager.getInstance();
            short s = 0;
            block5: while ((string = bufferedReader.readLine()) != null) {
                CaughtHost caughtHost;
                if (string.startsWith("#") || (caughtHost = this.parseCaughtHostFromLine(string)) == null) continue;
                byte by = ((PhexSecurityManager)object).controlHostAddressAccess(caughtHost.getHostAddress());
                switch (by) {
                    case 2: 
                    case 3: {
                        continue block5;
                    }
                }
                if (IPUtils.isPortInUserInvalidList(caughtHost.getHostAddress())) continue;
                this.addPersistentCaughtHost(caughtHost);
                if (s != 2 && this.caughtHosts.isFull(s)) {
                    s = (short)(s + 1);
                }
                this.addToCaughtHostFetcher(caughtHost, s);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
    }

    private CaughtHost parseCaughtHostFromLine(String string) {
        long l;
        long l2;
        int n;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        if (n2 == 1) {
            string2 = string;
            n = -1;
            l2 = -1L;
            l = -1L;
        } else if (n2 == 4) {
            string2 = stringTokenizer.nextToken();
            try {
                l2 = Long.parseLong(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                l2 = -1L;
            }
            try {
                l = Long.parseLong(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                l = -1L;
            }
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else {
            Logger.logWarning((short)16, "Unknown HostCache line format: " + string);
            return null;
        }
        byte[] byArray = HostAddress.parseIP(string2);
        if (byArray == null) {
            return null;
        }
        int n3 = HostAddress.parsePort(string2);
        if (n3 == -1) {
            return null;
        }
        HostAddress hostAddress = new HostAddress(byArray, n3);
        CaughtHost caughtHost = new CaughtHost(hostAddress);
        if (n > 0) {
            caughtHost.setDailyUptime(n);
        }
        if (l2 > 0L) {
            caughtHost.setLastFailedConnection(l2);
        }
        if (l > 0L) {
            caughtHost.setLastSuccessfulConnection(l);
        }
        return caughtHost;
    }

    public synchronized void saveHostsContainer() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        this.saveCaughtHosts();
        this.saveAutoConnectHosts();
        this.hasChangedSinceLastSave = false;
    }

    private synchronized void saveCaughtHosts() {
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getHostsFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Iterator iterator = this.catchedHostCache.iterator();
            while (iterator.hasNext()) {
                CaughtHost caughtHost = (CaughtHost)iterator.next();
                HostAddress hostAddress = caughtHost.getHostAddress();
                if (this.isInStartupHosts(hostAddress)) continue;
                bufferedWriter.write(hostAddress.getFullHostName() + "," + caughtHost.getLastFailedConnection() + "," + caughtHost.getLastSuccessfulConnection() + "," + caughtHost.getDailyUptime());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private boolean isInStartupHosts(HostAddress hostAddress) {
        int n;
        for (n = 0; n < DEFAULT_STARTUP_HOSTS.length; ++n) {
            if (!hostAddress.equals(DEFAULT_STARTUP_HOSTS[n])) continue;
            return true;
        }
        n = this.autoConnectHosts.size();
        for (int i = 0; i < n; ++i) {
            if (!hostAddress.equals(this.autoConnectHosts.get(i))) continue;
            return true;
        }
        return false;
    }

    public synchronized int getAutoConnectHostsCount() {
        return this.autoConnectHosts.size();
    }

    public synchronized HostAddress getAutoConnectHostAt(int n) {
        if (n >= this.autoConnectHosts.size()) {
            return null;
        }
        return (HostAddress)this.autoConnectHosts.get(n);
    }

    public synchronized void removeAllAutoConnectHosts() {
        for (int i = this.autoConnectHosts.size() - 1; i >= 0; --i) {
            this.removeAutoConnectHost((HostAddress)this.autoConnectHosts.get(i));
        }
    }

    public synchronized void addAutoConnectHost(HostAddress hostAddress) {
        this.insertAutoConnectHost(hostAddress, this.autoConnectHosts.size());
    }

    private synchronized void insertAutoConnectHost(HostAddress hostAddress, int n) {
        if (!this.autoConnectHosts.contains(hostAddress)) {
            this.autoConnectHosts.add(n, hostAddress);
            this.hasChangedSinceLastSave = true;
            this.fireAutoConnectHostAdded(n);
        }
    }

    public synchronized void removeAutoConnectHost(HostAddress hostAddress) {
        int n = this.autoConnectHosts.indexOf(hostAddress);
        if (n >= 0) {
            this.autoConnectHosts.remove(n);
            this.fireAutoConnectHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    private synchronized void addAutoConnectHosts() {
        NetworkManager networkManager = NetworkManager.getInstance();
        if (networkManager.getGnutellaNetwork() instanceof GeneralGnutellaNetwork) {
            int n = this.autoConnectHosts.size();
            for (int i = n - 1; i >= 0; --i) {
                CaughtHost caughtHost = new CaughtHost((HostAddress)this.autoConnectHosts.get(i));
                this.addToCaughtHostFetcher(caughtHost, (short)2);
            }
            if (n == 0) {
                this.addDefaultAutoConnectHosts();
            }
        }
    }

    private synchronized void addDefaultAutoConnectHosts() {
        NetworkManager networkManager = NetworkManager.getInstance();
        if (networkManager.getGnutellaNetwork() instanceof GeneralGnutellaNetwork) {
            for (int i = DEFAULT_STARTUP_HOSTS.length - 1; i >= 0; --i) {
                CaughtHost caughtHost = new CaughtHost(DEFAULT_STARTUP_HOSTS[i]);
                this.addToCaughtHostFetcher(caughtHost, (short)2);
            }
        }
    }

    private void loadAutoConnectHostsFromFile() {
        try {
            String string;
            File file = Environment.getInstance().getPhexConfigFile("autoconnecthosts.cfg");
            if (!file.exists()) {
                this.copyDefaultAutoConnectHosts();
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                try {
                    this.insertAutoConnectHost(new HostAddress(string), this.autoConnectHosts.size());
                }
                catch (MalformedHostAddressException malformedHostAddressException) {}
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private void copyDefaultAutoConnectHosts() {
        for (int i = 0; i < DEFAULT_STARTUP_HOSTS.length; ++i) {
            this.addAutoConnectHost(DEFAULT_STARTUP_HOSTS[i]);
        }
    }

    private synchronized void saveAutoConnectHosts() {
        try {
            File file = Environment.getInstance().getPhexConfigFile("autoconnecthosts.cfg");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.autoConnectHosts.size(); ++i) {
                HostAddress hostAddress = (HostAddress)this.autoConnectHosts.get(i);
                bufferedWriter.write(hostAddress.getFullHostName());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.add(caughtHostsChangeListener);
    }

    public void removeCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.listenerList.remove(caughtHostsChangeListener);
    }

    private void fireCaughtHostsChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.caughtHostsChanged();
                }
            }
        });
    }

    private void fireAutoConnectHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.autoConnectHostAdded(n);
                }
            }
        });
    }

    private void fireAutoConnectHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = CaughtHostsContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    CaughtHostsChangeListener caughtHostsChangeListener = (CaughtHostsChangeListener)objectArray[i];
                    caughtHostsChangeListener.autoConnectHostRemoved(n);
                }
            }
        });
    }

    private class SaveHostsContainerTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveHostsContainerTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveHostsContainerRunner(), "SaveHostsContainer");
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }

    private class SaveHostsContainerRunner
    implements Runnable {
        private SaveHostsContainerRunner() {
        }

        public void run() {
            CaughtHostsContainer.this.saveHostsContainer();
        }
    }
}

