/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.connection.NetworkManager;
import phex.event.AsynchronousDispatcher;
import phex.event.BookmarkedHostsChangeListener;
import phex.host.FavoriteHost;
import phex.host.HostAddress;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBFavoriteHost;
import phex.xml.XJBFavoritesList;
import phex.xml.XJBPhex;
import phex.xml.XMLBuilder;

public class FavoritesContainer {
    private ArrayList listenerList = new ArrayList(2);
    private ArrayList favoritesList = new ArrayList();
    private boolean hasChangedSinceLastSave = false;

    public FavoritesContainer() {
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
    }

    public void initializeFavorites() {
        this.favoritesList.clear();
        this.loadFromFile();
    }

    public synchronized void addFavorites(HostAddress[] hostAddressArray) {
        for (int i = 0; i < hostAddressArray.length; ++i) {
            FavoriteHost favoriteHost = new FavoriteHost(hostAddressArray[i]);
            this.insertBookmarkedHost(favoriteHost, this.favoritesList.size());
        }
    }

    public synchronized void addFavorite(HostAddress hostAddress) {
        FavoriteHost favoriteHost = new FavoriteHost(hostAddress);
        this.insertBookmarkedHost(favoriteHost, this.favoritesList.size());
    }

    private void loadFromFile() {
        Logger.logMessage(Logger.FINE, (short)16, "Loading favorites file.");
        NetworkManager networkManager = NetworkManager.getInstance();
        File file = networkManager.getGnutellaNetwork().getFavoritesFile();
        try {
            if (!file.exists()) {
                return;
            }
            XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.SEVERE, (short)255, "Error loading bookmarked hosts list.");
                return;
            }
            XJBFavoritesList xJBFavoritesList = xJBPhex.getFavoritesList();
            if (xJBFavoritesList == null) {
                Logger.logMessage(Logger.FINE, (short)2, "No XJBBookmarkedHostList found.");
            }
            Iterator iterator = xJBFavoritesList.getFavoritesList().iterator();
            while (iterator.hasNext()) {
                Object object;
                HostAddress hostAddress;
                XJBFavoriteHost xJBFavoriteHost = (XJBFavoriteHost)iterator.next();
                int n = xJBFavoriteHost.getPort();
                String string = xJBFavoriteHost.getHostName();
                if (string != null) {
                    hostAddress = new HostAddress(string, n);
                } else {
                    object = xJBFavoriteHost.getIp();
                    hostAddress = new HostAddress((byte[])object, n);
                }
                object = new FavoriteHost(hostAddress);
                this.insertBookmarkedHost((FavoriteHost)object, this.favoritesList.size());
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return;
        }
    }

    public synchronized void saveFavoriteHosts() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        try {
            Object object;
            Object object2;
            ObjectFactory objectFactory = new ObjectFactory();
            PhexElement phexElement = objectFactory.createPhexElement();
            phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
            XJBFavoritesList xJBFavoritesList = objectFactory.createXJBFavoritesList();
            phexElement.setFavoritesList(xJBFavoritesList);
            List list = xJBFavoritesList.getFavoritesList();
            Iterator iterator = this.favoritesList.iterator();
            while (iterator.hasNext()) {
                object2 = (FavoriteHost)iterator.next();
                object = objectFactory.createXJBFavoriteHost();
                HostAddress hostAddress = ((FavoriteHost)object2).getHostAddress();
                if (hostAddress.isIpHostName()) {
                    object.setIp(hostAddress.getHostIP());
                } else {
                    object.setHostName(hostAddress.getHostName());
                }
                object.setPort(hostAddress.getPort());
                list.add(object);
            }
            object2 = NetworkManager.getInstance();
            object = ((NetworkManager)object2).getGnutellaNetwork().getFavoritesFile();
            XMLBuilder.saveToFile((File)object, phexElement);
            this.hasChangedSinceLastSave = false;
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    public synchronized int getBookmarkedHostsCount() {
        return this.favoritesList.size();
    }

    public synchronized FavoriteHost getBookmarkedHostAt(int n) {
        if (n >= this.favoritesList.size()) {
            return null;
        }
        return (FavoriteHost)this.favoritesList.get(n);
    }

    private synchronized void insertBookmarkedHost(FavoriteHost favoriteHost, int n) {
        if (!this.favoritesList.contains(favoriteHost)) {
            this.favoritesList.add(n, favoriteHost);
            this.hasChangedSinceLastSave = true;
            this.fireBookmarkedHostAdded(n);
        }
    }

    public synchronized void removeBookmarkedHost(FavoriteHost favoriteHost) {
        int n = this.favoritesList.indexOf(favoriteHost);
        if (n >= 0) {
            this.favoritesList.remove(n);
            this.fireBookmarkedHostRemoved(n);
            this.hasChangedSinceLastSave = true;
        }
    }

    public void addBookmarkedHostsChangeListener(BookmarkedHostsChangeListener bookmarkedHostsChangeListener) {
        this.listenerList.add(bookmarkedHostsChangeListener);
    }

    public void removeBookmarkedHostsChangeListener(BookmarkedHostsChangeListener bookmarkedHostsChangeListener) {
        this.listenerList.remove(bookmarkedHostsChangeListener);
    }

    private void fireBookmarkedHostAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FavoritesContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    BookmarkedHostsChangeListener bookmarkedHostsChangeListener = (BookmarkedHostsChangeListener)objectArray[i];
                    bookmarkedHostsChangeListener.bookmarkedHostAdded(n);
                }
            }
        });
    }

    private void fireBookmarkedHostRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FavoritesContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    BookmarkedHostsChangeListener bookmarkedHostsChangeListener = (BookmarkedHostsChangeListener)objectArray[i];
                    bookmarkedHostsChangeListener.bookmarkedHostRemoved(n);
                }
            }
        });
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveFavoritesRunner(), "SaveBookmarkedHosts");
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }

    private class SaveFavoritesRunner
    implements Runnable {
        private SaveFavoritesRunner() {
        }

        public void run() {
            FavoritesContainer.this.saveFavoriteHosts();
        }
    }
}

