/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionObserver;
import phex.connection.NetworkManager;
import phex.event.NetworkHostsChangeListener;
import phex.host.CaughtHostsContainer;
import phex.host.FavoritesContainer;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.host.UltrapeerCapabilityChecker;
import phex.utils.Logger;

public final class HostManager
implements Manager {
    private static final int MAX_PARALLEL_CONNECTION_TRIES = 20;
    private static HostManager instance;
    private NetworkManager networkMgr;
    private CaughtHostsContainer caughtHostsContainer;
    private NetworkHostsContainer networkHostsContainer;
    private FavoritesContainer favoritesContainer = new FavoritesContainer();
    private UltrapeerCapabilityChecker upChecker;

    private HostManager() {
        this.caughtHostsContainer = new CaughtHostsContainer();
    }

    public static HostManager getInstance() {
        if (instance == null) {
            instance = new HostManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.networkMgr = NetworkManager.getInstance();
        this.networkHostsContainer = new NetworkHostsContainer();
        ConnectionObserver connectionObserver = new ConnectionObserver();
        connectionObserver.start();
        NetworkManager networkManager = NetworkManager.getInstance();
        networkManager.addNetworkListener(this.networkHostsContainer);
        this.upChecker = new UltrapeerCapabilityChecker();
        return true;
    }

    public void startupCompletedNotify() {
        Environment.getInstance().scheduleTimerTask(new HostCheckTimer(), 2000L, 2000L);
    }

    public void shutdown() {
        try {
            this.caughtHostsContainer.saveHostsContainer();
            this.favoritesContainer.saveFavoriteHosts();
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    public void acceptIncomingConnection(Host host, String string) throws IOException {
        ConnectionEngine connectionEngine = new ConnectionEngine(host);
        connectionEngine.initializeIncomingConnection(string);
        connectionEngine.processIncomingData();
    }

    public FavoritesContainer getFavoritesContainer() {
        return this.favoritesContainer;
    }

    public CaughtHostsContainer getCaughtHostsContainer() {
        return this.caughtHostsContainer;
    }

    public NetworkHostsContainer getNetworkHostsContainer() {
        return this.networkHostsContainer;
    }

    public boolean isShieldedLeafNode() {
        return this.networkHostsContainer.isShieldedLeafNode();
    }

    public boolean isAbleToBecomeUltrapeer() {
        if (this.isUltrapeer()) {
            return true;
        }
        return !this.isShieldedLeafNode() && ServiceManager.sCfg.allowToBecomeUP && this.upChecker.isUltrapeerCapable();
    }

    public boolean isUltrapeer() {
        return ServiceManager.sCfg.allowToBecomeUP && ServiceManager.sCfg.forceToBeUltrapeer || this.networkHostsContainer.hasLeafConnections();
    }

    public boolean areIncommingSlotsAdvertised() {
        if (this.networkHostsContainer.isShieldedLeafNode()) {
            return false;
        }
        return this.networkHostsContainer.hasPeerSlotsAvailable() || this.networkHostsContainer.hasUltrapeerSlotsAvailable() || this.networkHostsContainer.hasLeafSlotsAvailable();
    }

    public boolean isAbleToBecomeLeafNode() {
        if (!ServiceManager.sCfg.allowToBecomeLeaf) {
            return false;
        }
        return !this.isAbleToBecomeUltrapeer() || !this.networkHostsContainer.hasLeafConnections() && !this.networkHostsContainer.hasUltrapeerConnections();
    }

    public void addConnectedHost(Host host) {
        this.networkHostsContainer.addConnectedHost(host);
    }

    public void disconnectHost(Host host) {
        this.networkHostsContainer.disconnectHost(host);
    }

    public void addIncomingHost(Host host) {
        this.networkHostsContainer.addIncomingHost(host);
    }

    public void removeAllNetworkHosts() {
        this.networkHostsContainer.removeAllNetworkHosts();
    }

    public void removeNetworkHosts(Host[] hostArray) {
        this.networkHostsContainer.removeNetworkHosts(hostArray);
    }

    public void removeNetworkHost(Host host) {
        this.networkHostsContainer.removeNetworkHost(host);
    }

    public void addNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.networkHostsContainer.addNetworkHostsChangeListener(networkHostsChangeListener);
    }

    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.networkHostsContainer.removeNetworkHostsChangeListener(networkHostsChangeListener);
    }

    public void doAutoConnectCheck() {
        int n;
        int n2;
        if (!this.networkMgr.isNetworkJoined() || !this.networkMgr.isConnected()) {
            return;
        }
        if (this.isAbleToBecomeUltrapeer()) {
            n2 = this.networkHostsContainer.getUltrapeerConnectionCount();
            n = ServiceManager.sCfg.up2upConnections;
        } else if (this.isShieldedLeafNode() || ServiceManager.sCfg.allowToBecomeLeaf) {
            n2 = this.networkHostsContainer.getUltrapeerConnectionCount();
            n = ServiceManager.sCfg.leaf2upConnections;
        } else {
            n2 = this.networkHostsContainer.getTotalConnectionCount();
            n = ServiceManager.sCfg.peerConnections;
        }
        int n3 = (n - n2) * 4;
        int n4 = this.networkHostsContainer.getNetworkHostCount() - n2 - this.networkHostsContainer.getNetworkHostCount(1);
        if ((n3 -= n4) > 0) {
            n3 = Math.min(n3, 20);
            this.networkHostsContainer.createOutConnectionToNextHosts(n3);
        }
    }

    private class HostCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 2000L;

        private HostCheckTimer() {
        }

        public void run() {
            try {
                HostManager.this.doAutoConnectCheck();
                HostManager.this.networkHostsContainer.periodicallyCheckHosts();
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }
}

