/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.LinkedMap;
import phex.common.Environment;
import phex.http.HTTPHeader;
import phex.utils.Logger;

public class HTTPHeaderGroup {
    public static final HTTPHeader[] EMPTY_HTTPHEADER_ARRAY = new HTTPHeader[0];
    public static HTTPHeaderGroup EMPTY_HEADERGROUP;
    public static String COLON_SEPARATOR;
    public static HTTPHeaderGroup COMMON_HANDSHAKE_GROUP;
    public static HTTPHeaderGroup ACCEPT_HANDSHAKE_GROUP;
    protected Map headerFields;
    protected boolean lenient;

    public HTTPHeaderGroup(boolean bl) {
        this.lenient = bl;
        this.headerFields = new LinkedMap();
    }

    public HTTPHeaderGroup(HTTPHeaderGroup hTTPHeaderGroup) {
        this.headerFields = new LinkedMap(hTTPHeaderGroup.headerFields);
        this.lenient = hTTPHeaderGroup.lenient;
    }

    public HTTPHeaderGroup(int n, boolean bl) {
        this.lenient = bl;
        this.headerFields = new LinkedMap(n);
    }

    private HTTPHeaderGroup() {
    }

    public void addHeader(HTTPHeader hTTPHeader) {
        String string = this.lenient ? hTTPHeader.getName().toLowerCase() : hTTPHeader.getName();
        ArrayList<HTTPHeader> arrayList = (ArrayList<HTTPHeader>)this.headerFields.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<HTTPHeader>();
            this.headerFields.put(string, arrayList);
        }
        arrayList.add(hTTPHeader);
    }

    public void addHeaders(HTTPHeader[] hTTPHeaderArray) {
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            String string = this.lenient ? hTTPHeaderArray[i].getName().toLowerCase() : hTTPHeaderArray[i].getName();
            ArrayList<HTTPHeader> arrayList = (ArrayList<HTTPHeader>)this.headerFields.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<HTTPHeader>();
                this.headerFields.put(string, arrayList);
            }
            arrayList.add(hTTPHeaderArray[i]);
        }
    }

    public void replaceHeaders(HTTPHeaderGroup hTTPHeaderGroup) {
        if (this.lenient == hTTPHeaderGroup.lenient) {
            this.headerFields.putAll(hTTPHeaderGroup.headerFields);
        } else {
            Iterator iterator = hTTPHeaderGroup.headerFields.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ArrayList arrayList = (ArrayList)this.headerFields.get(string);
                String string2 = ((HTTPHeader)arrayList.get(0)).getName();
                if (this.lenient) {
                    string2 = string2.toLowerCase();
                }
                this.headerFields.put(string2, arrayList);
            }
        }
    }

    public HTTPHeader getHeader(String string) {
        if (this.lenient) {
            string = string.toLowerCase();
        }
        ArrayList arrayList = null;
        arrayList = (ArrayList)this.headerFields.get(string);
        if (arrayList != null) {
            return (HTTPHeader)arrayList.get(0);
        }
        return null;
    }

    public HTTPHeader[] getHeaders(String string) {
        if (this.lenient) {
            string = string.toLowerCase();
        }
        ArrayList arrayList = null;
        arrayList = (ArrayList)this.headerFields.get(string);
        if (arrayList == null) {
            return EMPTY_HTTPHEADER_ARRAY;
        }
        HTTPHeader[] hTTPHeaderArray = new HTTPHeader[arrayList.size()];
        return arrayList.toArray(hTTPHeaderArray);
    }

    public boolean isHeaderValueEqual(String string, String string2) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return false;
        }
        String string3 = hTTPHeader.getValue();
        return string2.equalsIgnoreCase(string3);
    }

    public boolean isHeaderValueContaining(String string, String string2) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return false;
        }
        String string3 = hTTPHeader.getValue();
        if (string3 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase(string3)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string2.equalsIgnoreCase(string4)) continue;
            return true;
        }
        return false;
    }

    public byte getByteHeaderValue(String string, byte by) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return by;
        }
        try {
            byte by2 = hTTPHeader.byteValue();
            return by2;
        }
        catch (NumberFormatException numberFormatException) {
            return by;
        }
    }

    public int getIntHeaderValue(String string, int n) {
        HTTPHeader hTTPHeader = this.getHeader(string);
        if (hTTPHeader == null) {
            return n;
        }
        try {
            int n2 = hTTPHeader.intValue();
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public String buildHTTPHeaderString() {
        StringBuffer stringBuffer = new StringBuffer(30 * this.headerFields.size());
        Iterator iterator = this.headerFields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.headerFields.get(string);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                HTTPHeader hTTPHeader = (HTTPHeader)iterator2.next();
                stringBuffer.append(hTTPHeader.getName());
                stringBuffer.append(COLON_SEPARATOR);
                stringBuffer.append(hTTPHeader.getValue());
                stringBuffer.append("\r\n");
            }
        }
        return stringBuffer.toString();
    }

    public static HTTPHeaderGroup createDefaultRequestHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(false);
        hTTPHeaderGroup.addHeader(new HTTPHeader("User-Agent", Environment.getPhexVendor()));
        return hTTPHeaderGroup;
    }

    public static HTTPHeaderGroup createDefaultResponseHeaders() {
        HTTPHeaderGroup hTTPHeaderGroup = new HTTPHeaderGroup(false);
        hTTPHeaderGroup.addHeader(new HTTPHeader("Server", Environment.getPhexVendor()));
        return hTTPHeaderGroup;
    }

    static {
        COLON_SEPARATOR = ": ";
        try {
            EMPTY_HEADERGROUP = new EmptyHTTPHeaders();
            COMMON_HANDSHAKE_GROUP = new HTTPHeaderGroup(false);
            COMMON_HANDSHAKE_GROUP.addHeader(new HTTPHeader("User-Agent", Environment.getPhexVendor()));
            ACCEPT_HANDSHAKE_GROUP = new HTTPHeaderGroup(COMMON_HANDSHAKE_GROUP);
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("GGEP", "0.5"));
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("Vendor-Message", "0.1"));
            ACCEPT_HANDSHAKE_GROUP.addHeader(new HTTPHeader("X-Requeries", "false"));
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    private static class EmptyHTTPHeaders
    extends HTTPHeaderGroup {
        EmptyHTTPHeaders() {
            this.headerFields = Collections.EMPTY_MAP;
            this.lenient = false;
        }

        public void addHeader(HTTPHeader hTTPHeader) {
            throw new UnsupportedOperationException("Modification of empty http headers not allowed");
        }

        public void addHeaders(HTTPHeader[] hTTPHeaderArray) {
            throw new UnsupportedOperationException("Modification of empty http headers not allowed");
        }

        public HTTPHeader getHeader(String string) {
            return null;
        }

        public HTTPHeader[] getHeaders(String string) {
            return EMPTY_HTTPHEADER_ARRAY;
        }

        public String buildHTTPHeaderString() {
            return "";
        }
    }
}

