/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import phex.http.IRating;
import phex.http.Range;
import phex.utils.Logger;

public class HTTPRangeSet {
    private static final String BYTES = "bytes";
    public static final int NOT_SET = -1;
    private ArrayList rangeList = new ArrayList(4);

    public HTTPRangeSet() {
    }

    public HTTPRangeSet(long l) {
        this();
        Range range = new Range(l);
        this.rangeList.add(range);
    }

    public HTTPRangeSet(long l, long l2) {
        this();
        Range range = new Range(l, l2);
        this.rangeList.add(range);
    }

    public int size() {
        return this.rangeList.size();
    }

    public Range makeRange(long l, long l2, IRating iRating) {
        return new Range(l, l2, iRating);
    }

    public void addRange(long l) {
        Range range = new Range(l);
        this.rangeList.add(range);
    }

    public void addRange(long l, long l2) {
        Range range = new Range(l, l2);
        this.rangeList.add(range);
    }

    public void setRating(IRating iRating) {
        Iterator iterator = this.rangeList.iterator();
        Logger.logMessage(Logger.INFO, (short)2, "Setting rating to " + iRating + " en masse.");
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            range.setRating(iRating);
        }
    }

    public Range getFirstRange() {
        if (this.rangeList.size() > 0) {
            return (Range)this.rangeList.get(0);
        }
        return null;
    }

    public Iterator getIterator() {
        return this.rangeList.iterator();
    }

    public Collection getRangeSet() {
        return this.rangeList;
    }

    public String buildXAvailableRangesString() {
        if (this.rangeList.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("bytes ");
        Iterator iterator = this.rangeList.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            stringBuffer.append(range.buildHTTPRangeString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public static HTTPRangeSet parseHTTPRangeSet(String string) {
        int n;
        if (!(string = string.toLowerCase()).startsWith(BYTES)) {
            return null;
        }
        try {
            string = string.substring(6).trim();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Logger.logError(stringIndexOutOfBoundsException, "Invalid RangeSet value: '" + string + "'.");
            return null;
        }
        int n2 = 0;
        HTTPRangeSet hTTPRangeSet = new HTTPRangeSet();
        do {
            int n3;
            String string2;
            if ((n = string.indexOf(44, n2)) == -1) {
                n = string.length();
            }
            if ((string2 = string.substring(n2, n).trim()).charAt(0) == '-') {
                n3 = string2.indexOf(32);
                if (n3 == -1) {
                    n3 = string2.length();
                }
                String string3 = string2.substring(1, n3);
                try {
                    long l = Long.parseLong(string3);
                    hTTPRangeSet.addRange(l);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            n3 = string2.indexOf(45);
            try {
                String string4 = string2.substring(0, n3);
                long l = Long.parseLong(string4);
                if (n3 + 1 >= string2.length()) {
                    hTTPRangeSet.addRange(l, -1L);
                } else {
                    String string5 = string2.substring(n3 + 1);
                    long l2 = Long.parseLong(string5);
                    hTTPRangeSet.addRange(l, l2);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n2 = n + 1;
        } while (n != string.length());
        return hTTPRangeSet;
    }

    public static void main(String[] stringArray) {
        Iterator iterator = HTTPRangeSet.parseHTTPRangeSet("bytes=434176-2640890").getIterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        iterator = HTTPRangeSet.parseHTTPRangeSet("bytes=434176-2640890,1-4,-7,7-10").getIterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }
}

