/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.http.CandidateRating;
import phex.http.IRating;

public class PriorityRating
implements IRating {
    public static final int NOT_SET = 0;
    public static final double CANDIDATE_POWER = 1.0;
    private long sumOfTransferSpeeds;
    private long nCandidates;

    public PriorityRating() {
        this(0L, 0L);
    }

    public PriorityRating(IRating iRating) {
        this(((PriorityRating)iRating).sumOfTransferSpeeds, ((PriorityRating)iRating).nCandidates);
    }

    public PriorityRating(long l, long l2) {
        this.sumOfTransferSpeeds = l;
        this.nCandidates = l2;
    }

    public String toString() {
        if (this.nCandidates == 0L) {
            return new String("");
        }
        return new String("[" + this.sumOfTransferSpeeds + "]");
    }

    public static IRating derive(IRating iRating) {
        CandidateRating candidateRating = (CandidateRating)iRating;
        if (candidateRating.hasValidTransferSpeed()) {
            return new PriorityRating(Math.round(Math.pow(candidateRating.getTransferSpeed(), 1.0)), 1L);
        }
        return new PriorityRating(0L, 0L);
    }

    public void accumulate(IRating iRating) {
        CandidateRating candidateRating = (CandidateRating)iRating;
        if (candidateRating != null && candidateRating.hasValidTransferSpeed()) {
            this.sumOfTransferSpeeds += Math.round(Math.pow(candidateRating.getTransferSpeed(), 1.0));
            ++this.nCandidates;
        } else {
            this.sumOfTransferSpeeds += 0L;
        }
    }

    public void set(String string, long l) throws Exception {
        throw new Error("Should never be called - can be set during construction");
    }

    public long getValue() {
        if (this.nCandidates == 0L) {
            return 1000000L;
        }
        return this.sumOfTransferSpeeds;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            PriorityRating priorityRating = (PriorityRating)object;
            return this.sumOfTransferSpeeds == priorityRating.sumOfTransferSpeeds;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return (int)(this.getValue() % 65535L);
    }
}

