/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.http.IRating;
import phex.utils.Logger;

public class Range {
    public static final int NOT_SET = -1;
    private long suffixLength;
    private long startOffset;
    private long endOffset;
    private IRating rating;

    public Range(long l) {
        this.startOffset = -1L;
        this.endOffset = -1L;
        this.suffixLength = l;
        this.rating = null;
    }

    public Range(long l, long l2) {
        this(l, l2, null);
    }

    public Range(long l, long l2, IRating iRating) {
        this.startOffset = l;
        this.endOffset = l2;
        this.suffixLength = -1L;
        this.rating = iRating;
    }

    public void update(long l) {
        this.startOffset = -1L;
        this.endOffset = -1L;
        this.suffixLength = l;
    }

    public void update(long l, long l2) {
        this.startOffset = l;
        this.endOffset = l2;
        this.suffixLength = -1L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Range: " + this.startOffset + "-" + this.endOffset + " (" + this.rating + ")]");
        return stringBuffer.toString();
    }

    public long getStartOffset(long l) {
        if (this.suffixLength == -1L) {
            return this.startOffset;
        }
        return l - this.suffixLength;
    }

    public long getEndOffset(long l) {
        if (this.suffixLength == -1L && this.endOffset != -1L) {
            return Math.min(this.endOffset, l);
        }
        return l;
    }

    public void accumulate(IRating iRating) {
        this.rating.accumulate(iRating);
    }

    public void setRating(IRating iRating) {
        if (this.rating == iRating) {
            return;
        }
        Logger.logMessage(Logger.INFO, (short)2, "Changing rating from " + this.rating + " to " + iRating + " for range: " + this.startOffset + " - " + this.endOffset);
        this.rating = iRating;
    }

    public IRating getRating() {
        return this.rating;
    }

    public boolean isRangeSatisfiable(Range range, long l) {
        long l2 = range.getStartOffset(l);
        return this.getStartOffset(l) <= l2 && l2 <= this.getEndOffset(l);
    }

    public String buildHTTPRangeString() {
        if (this.suffixLength == -1L) {
            return String.valueOf(this.startOffset) + '-' + String.valueOf(this.endOffset);
        }
        return '-' + String.valueOf(this.suffixLength);
    }
}

