/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import phex.host.HostAddress;
import phex.msg.InvalidGGEPBlockException;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class GGEPBlock {
    public static final byte MAGIC_NUMBER = -61;
    public static final String BROWSE_HOST_HEADER_ID = "BH";
    public static final String ALTERNATE_LOCATIONS_HEADER_ID = "ALT";
    public static final String AVARAGE_DAILY_UPTIME = "DU";
    public static final String ULTRAPEER_ID = "UP";
    public static final String VENDOR_CODE_ID = "VC";
    public static final String PATH_INFO_HEADER_ID = "PATH";
    public static final String PUSH_PROXY_HEADER_ID = "PUSH";
    private HashMap headerToDataMap = new HashMap(3);
    private static byte[] browseHostGGEPBlock;

    public void debugDump() {
        System.out.println("--------------------------------------");
        Iterator iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            System.out.println(k + " = " + this.headerToDataMap.get(k));
        }
        System.out.println("--------------------------------------");
    }

    private void addExtension(String string) {
        this.addExtension(string, "".getBytes());
    }

    public void addExtension(String string, byte[] byArray) {
        this.headerToDataMap.put(string, byArray);
    }

    public void addExtension(String string, int n) {
        this.addExtension(string, IOUtil.serializeInt2MinLE(n));
    }

    public byte[] getExtensionData(String string) {
        return (byte[])this.headerToDataMap.get(string);
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(30);
        byteArrayOutputStream.write(-61);
        Iterator iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            byte[] byArray = (byte[])this.headerToDataMap.get(string);
            int n = 0;
            if (!iterator.hasNext()) {
                n |= 0x80;
            }
            byte[] byArray2 = string.getBytes();
            byteArrayOutputStream.write(n |= byArray2.length);
            byteArrayOutputStream.write(byArray2);
            int n2 = byArray.length;
            int n3 = n2 & 0x3F000;
            if (n3 != 0) {
                n3 >>= 12;
                n3 = 0x80 | n3;
                byteArrayOutputStream.write(n3);
            }
            if ((n3 = n2 & 0xFC0) != 0) {
                n3 >>= 6;
                n3 = 0x80 | n3;
                byteArrayOutputStream.write(n3);
            }
            n3 = n2 & 0x3F;
            n3 = 0x40 | n3;
            byteArrayOutputStream.write(n3);
            if (n2 <= 0) continue;
            byteArrayOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isExtensionAvailable(String string) {
        return this.headerToDataMap.containsKey(string);
    }

    public static byte[] getQueryReplyGGEPBlock(boolean bl, HostAddress[] hostAddressArray) {
        if (hostAddressArray != null && hostAddressArray.length > 0) {
            GGEPBlock gGEPBlock = new GGEPBlock();
            if (bl) {
                gGEPBlock.addExtension(BROWSE_HOST_HEADER_ID);
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = Math.min(hostAddressArray.length, 4);
                for (int i = 0; i < n; ++i) {
                    byteArrayOutputStream.write(hostAddressArray[i].getHostIP());
                    IOUtil.serializeShortLE((short)hostAddressArray[i].getPort(), byteArrayOutputStream);
                }
                gGEPBlock.addExtension(PUSH_PROXY_HEADER_ID, byteArrayOutputStream.toByteArray());
                byte[] byArray = gGEPBlock.getBytes();
                return byArray;
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
                return IOUtil.EMPTY_BYTE_ARRAY;
            }
        }
        if (bl) {
            if (browseHostGGEPBlock == null) {
                GGEPBlock gGEPBlock = new GGEPBlock();
                gGEPBlock.addExtension(BROWSE_HOST_HEADER_ID);
                try {
                    browseHostGGEPBlock = gGEPBlock.getBytes();
                }
                catch (IOException iOException) {
                    Logger.logError(iOException);
                }
            }
            return browseHostGGEPBlock;
        }
        return IOUtil.EMPTY_BYTE_ARRAY;
    }

    public static boolean isExtensionHeaderInBlocks(GGEPBlock[] gGEPBlockArray, String string) {
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            if (!gGEPBlockArray[i].isExtensionAvailable(string)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getExtensionDataInBlocks(GGEPBlock[] gGEPBlockArray, String string) {
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            if (!gGEPBlockArray[i].isExtensionAvailable(string)) continue;
            return gGEPBlockArray[i].getExtensionData(string);
        }
        return null;
    }

    public static GGEPBlock[] parseGGEPBlocks(byte[] byArray, int n) throws InvalidGGEPBlockException {
        GGEPParser gGEPParser = new GGEPParser();
        return gGEPParser.parseGGEPBlocks(byArray, n);
    }

    public static GGEPBlock[] parseGGEPBlocks(PushbackInputStream pushbackInputStream) throws InvalidGGEPBlockException, IOException {
        GGEPParser gGEPParser = new GGEPParser();
        return gGEPParser.parseGGEPBlocks(pushbackInputStream);
    }

    public static void debugDumpBlocks(GGEPBlock[] gGEPBlockArray) {
        for (int i = 0; i < gGEPBlockArray.length; ++i) {
            gGEPBlockArray[i].debugDump();
        }
    }

    private static class GGEPParser {
        private int offset;
        private ArrayList ggepList = new ArrayList(3);

        public GGEPBlock[] parseGGEPBlocks(PushbackInputStream pushbackInputStream) throws InvalidGGEPBlockException, IOException {
            byte by;
            while ((by = (byte)pushbackInputStream.read()) != -1) {
                if (by != -61) {
                    pushbackInputStream.unread(by);
                    break;
                }
                this.ggepList.add(this.parseGGEPBlock(pushbackInputStream));
            }
            GGEPBlock[] gGEPBlockArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(gGEPBlockArray);
            return gGEPBlockArray;
        }

        private GGEPBlock parseGGEPBlock(InputStream inputStream) throws InvalidGGEPBlockException, IOException {
            GGEPBlock gGEPBlock = new GGEPBlock();
            boolean bl = false;
            while (!bl) {
                int n = inputStream.read();
                if ((n & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                bl = (n & 0x80) != 0;
                boolean bl2 = (n & 0x40) != 0;
                boolean bl3 = (n & 0x20) != 0;
                short s = (short)(n & 0xF);
                if (s == 0) {
                    throw new InvalidGGEPBlockException();
                }
                byte[] byArray = new byte[s];
                inputStream.read(byArray, 0, s);
                String string = new String(byArray, 0, (int)s);
                int n2 = this.parseDataLength(inputStream);
                byte[] byArray2 = null;
                try {
                    if (n2 > 0) {
                        byArray2 = new byte[n2];
                        inputStream.read(byArray2, 0, n2);
                        if (bl3) {
                            byArray2 = IOUtil.inflate(byArray2);
                        }
                        if (bl2) {
                            byArray2 = IOUtil.cobsDecode(byArray2);
                        }
                    } else {
                        byArray2 = new byte[]{};
                    }
                    gGEPBlock.addExtension(string, byArray2);
                }
                catch (DataFormatException dataFormatException) {
                    if (!Logger.isLevelTypeLogged(Logger.WARNING, (short)16)) continue;
                    Logger.logWarning((short)16, dataFormatException, "Invalid GGEP data format. Header: '" + string + "' Data: '" + HexConverter.toHexString(byArray2) + "'.");
                }
            }
            return gGEPBlock;
        }

        private int parseDataLength(InputStream inputStream) throws InvalidGGEPBlockException, IOException {
            byte by;
            int n = 0;
            int n2 = 0;
            do {
                if (++n2 > 3) {
                    throw new InvalidGGEPBlockException();
                }
                by = (byte)inputStream.read();
                n = n << 6 | by & 0x3F;
            } while (64 != (by & 0x40));
            return n;
        }

        public GGEPBlock[] parseGGEPBlocks(byte[] byArray, int n) throws InvalidGGEPBlockException {
            this.offset = n;
            while (byArray.length > this.offset && byArray[this.offset] == -61) {
                ++this.offset;
                this.ggepList.add(this.parseGGEPBlock(byArray));
            }
            GGEPBlock[] gGEPBlockArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(gGEPBlockArray);
            return gGEPBlockArray;
        }

        private GGEPBlock parseGGEPBlock(byte[] byArray) throws InvalidGGEPBlockException {
            GGEPBlock gGEPBlock = new GGEPBlock();
            boolean bl = false;
            while (!bl) {
                if (byArray.length > this.offset && (byArray[this.offset] & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                bl = (byArray[this.offset] & 0x80) != 0;
                boolean bl2 = (byArray[this.offset] & 0x40) != 0;
                boolean bl3 = (byArray[this.offset] & 0x20) != 0;
                short s = (short)(byArray[this.offset] & 0xF);
                if (s == 0) {
                    throw new InvalidGGEPBlockException();
                }
                ++this.offset;
                String string = new String(byArray, this.offset, (int)s);
                this.offset += s;
                int n = this.parseDataLength(byArray);
                byte[] byArray2 = null;
                try {
                    if (n > 0) {
                        byArray2 = new byte[n];
                        System.arraycopy(byArray, this.offset, byArray2, 0, n);
                        this.offset += n;
                        if (bl3) {
                            byArray2 = IOUtil.inflate(byArray2);
                        }
                        if (bl2) {
                            byArray2 = IOUtil.cobsDecode(byArray2);
                        }
                    } else {
                        byArray2 = new byte[]{};
                    }
                    gGEPBlock.addExtension(string, byArray2);
                }
                catch (DataFormatException dataFormatException) {
                    if (!Logger.isLevelTypeLogged(Logger.WARNING, (short)16)) continue;
                    Logger.logWarning((short)16, dataFormatException, "Invalid GGEP data format. Header: '" + string + "' Data: '" + HexConverter.toHexString(byArray2) + "'.");
                }
            }
            return gGEPBlock;
        }

        private int parseDataLength(byte[] byArray) throws InvalidGGEPBlockException {
            byte by;
            int n = 0;
            int n2 = 0;
            do {
                if (++n2 > 3) {
                    throw new InvalidGGEPBlockException();
                }
                by = byArray[this.offset];
                ++this.offset;
                n = n << 6 | by & 0x3F;
            } while (64 != (by & 0x40));
            return n;
        }
    }
}

