/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.host.HostAddress;
import phex.msg.GGEPBlock;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class GGEPExtension {
    public static HostAddress[] parseAltExtensionData(GGEPBlock[] gGEPBlockArray) {
        byte[] byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "ALT");
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 6 != 0) {
            Logger.logWarning((short)16, "Invalid ALT GGEPBlock length: " + HexConverter.toHexString(byArray));
            return null;
        }
        int n = byArray.length / 6;
        HostAddress[] hostAddressArray = new HostAddress[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 6;
            byte[] byArray2 = new byte[]{byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]};
            int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, n2 + 4));
            hostAddressArray[i] = new HostAddress(byArray2, n3);
        }
        return hostAddressArray;
    }

    public static HostAddress[] parsePushProxyExtensionData(GGEPBlock[] gGEPBlockArray) {
        byte[] byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "PUSH");
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 6 != 0) {
            Logger.logWarning((short)16, "Invalid PushProxy GGEPBlock length: " + HexConverter.toHexString(byArray));
            return null;
        }
        int n = byArray.length / 6;
        HostAddress[] hostAddressArray = new HostAddress[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 6;
            byte[] byArray2 = new byte[]{byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]};
            int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, n2 + 4));
            hostAddressArray[i] = new HostAddress(byArray2, n3);
        }
        return hostAddressArray;
    }
}

