/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.MsgPing;
import phex.msg.MsgPong;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.VendorMsg;
import phex.net.connection.Connection;
import phex.utils.IOUtil;

public class MessageProcessor {
    private MessageProcessor() {
    }

    public static Message parseMessage(Connection connection) throws IOException, InvalidMessageException {
        MsgHeader msgHeader = MessageProcessor.parseMessageHeader(connection, new byte[23]);
        if (msgHeader == null) {
            throw new IOException("Connection closed by remote host");
        }
        return MessageProcessor.parseMessage(msgHeader, connection);
    }

    public static Message parseMessage(MsgHeader msgHeader, Connection connection) throws IOException, InvalidMessageException {
        byte[] byArray = MessageProcessor.readMessageBody(connection, msgHeader.getDataLen());
        Message message = MessageProcessor.createMessageFromBody(msgHeader, byArray);
        return message;
    }

    public static Message createMessageFromBody(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        switch (msgHeader.getPayload()) {
            case 0: {
                return new MsgPing(msgHeader, byArray);
            }
            case 1: {
                return new MsgPong(msgHeader, byArray);
            }
            case 64: {
                return new MsgPushRequest(msgHeader, byArray);
            }
            case -127: {
                return new MsgQueryResponse(msgHeader, byArray);
            }
            case -128: {
                return new MsgQuery(msgHeader, byArray);
            }
            case 48: {
                return RouteTableUpdateMsg.parseMessage(msgHeader, byArray);
            }
            case 49: 
            case 50: {
                return VendorMsg.parseMessage(msgHeader, byArray);
            }
        }
        return null;
    }

    public static byte[] readMessageBody(Connection connection, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            int n3 = Math.min(n - i, 1024);
            n2 = connection.read(byArray, i, n3);
            if (n2 != -1) continue;
            throw new IOException("Connection closed by remote host");
        }
        return byArray;
    }

    public static MsgHeader parseMessageHeader(Connection connection, byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < 23; i += n) {
            n = connection.read(byArray, i, 23 - i);
            if (n != -1) continue;
            return null;
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        byte by = byArray[16];
        byte by2 = byArray[17];
        byte by3 = byArray[18];
        int n2 = IOUtil.deserializeIntLE(byArray, 19);
        MsgHeader msgHeader = new MsgHeader(new GUID(byArray2), by, by2, by3, n2);
        return msgHeader;
    }
}

