/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.Iterator;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.Manager;
import phex.common.QueryRoutingTable;
import phex.connection.NetworkManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.GUID;
import phex.msg.MsgPing;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.query.QueryManager;
import phex.query.QueryResultMonitor;
import phex.utils.GUIDRoutingTable;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.QueryGUIDRoutingTable;

public final class MsgManager
implements Manager {
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private QueryManager queryMgr;
    private QueryResultMonitor queryResultMonitor;
    private QueryRoutingTable lastSentQueryRoutingTable;
    private GUIDRoutingTable pingRoutingTable = new GUIDRoutingTable(120000L);
    private QueryGUIDRoutingTable queryRoutingTable = new QueryGUIDRoutingTable(300000L);
    private GUIDRoutingTable pushRoutingTable = new GUIDRoutingTable(420000L);
    private static MsgManager instance;

    private MsgManager() {
    }

    public static MsgManager getInstance() {
        if (instance == null) {
            instance = new MsgManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.queryMgr = QueryManager.getInstance();
        Environment.getInstance().scheduleTimerTask(new QRPUpdateTimer(), 10000L, 10000L);
        this.queryResultMonitor = new QueryResultMonitor();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public QueryResultMonitor getQueryResultMonitor() {
        return this.queryResultMonitor;
    }

    public QueryRoutingTable getLastSentQueryRoutingTable() {
        return this.lastSentQueryRoutingTable;
    }

    public synchronized boolean checkAndAddToPingRoutingTable(GUID gUID, Host host) {
        boolean bl = this.pingRoutingTable.checkAndAddRouting(gUID, host);
        return bl;
    }

    public synchronized boolean checkAndAddToQueryRoutingTable(GUID gUID, Host host) {
        boolean bl = this.queryRoutingTable.checkAndAddRouting(gUID, host);
        return bl;
    }

    public synchronized void addToPushRoutingTable(GUID gUID, Host host) {
        this.pushRoutingTable.addRouting(gUID, host);
    }

    public synchronized void removeHost(Host host) {
        this.queryMgr.removeHostQueries(host);
        this.pingRoutingTable.removeHost(host);
        this.queryRoutingTable.removeHost(host);
        this.pushRoutingTable.removeHost(host);
    }

    public synchronized Host getPushRouting(GUID gUID) {
        return this.pushRoutingTable.findRouting(gUID);
    }

    public synchronized Host getPingRouting(GUID gUID) {
        return this.pingRoutingTable.findRouting(gUID);
    }

    public synchronized QueryGUIDRoutingPair getQueryRouting(GUID gUID, int n) {
        return this.queryRoutingTable.findRoutingForQuerys(gUID, n);
    }

    public synchronized void processQueryResponse(Host host, MsgQueryResponse msgQueryResponse) {
        this.queryMgr.getSearchContainer().processQueryResponse(msgQueryResponse);
        this.queryMgr.getBackgroundSearchContainer().processQueryResponse(msgQueryResponse);
        this.queryResultMonitor.processResponse(msgQueryResponse);
    }

    public void forwardQuery(MsgQuery msgQuery, Host host) {
        boolean bl = this.hostMgr.isShieldedLeafNode();
        if (bl && host != null && host.isLeafUltrapeerConnection()) {
            return;
        }
        if (host.isUltrapeerLeafConnection()) {
            this.queryMgr.sendDynamicQuery(msgQuery, 50);
        } else if (!bl) {
            if (msgQuery.getHeader().getTTL() > 0) {
                this.forwardQueryToUltrapeers(msgQuery, host);
            }
            this.forwardQueryToLeaves(msgQuery, host);
        }
        if (msgQuery.getHeader().getTTL() > 0) {
            Host[] hostArray = this.hostsContainer.getPeerConnections();
            this.forwardQuery(msgQuery, host, hostArray);
        }
    }

    public void forwardQueryToLeaves(MsgQuery msgQuery, Host host) {
        Host[] hostArray = this.hostsContainer.getLeafConnections();
        this.forwardQuery(msgQuery, host, hostArray);
    }

    private void forwardQuery(MsgQuery msgQuery, Host host, Host[] hostArray) {
        for (int i = 0; i < hostArray.length; ++i) {
            QueryRoutingTable queryRoutingTable;
            if (hostArray[i] == host || (queryRoutingTable = hostArray[i].getLastReceivedRoutingTable()) != null && !queryRoutingTable.containsQuery(msgQuery)) continue;
            hostArray[i].queueMessageToSend(msgQuery);
        }
    }

    public void forwardQueryToUltrapeers(MsgQuery msgQuery, Host host) {
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        boolean bl = msgQuery.getHeader().getTTL() == 1;
        for (int i = 0; i < hostArray.length; ++i) {
            QueryRoutingTable queryRoutingTable;
            if (hostArray[i] == host || bl && hostArray[i].isUPQueryRoutingSupported() && (queryRoutingTable = hostArray[i].getLastReceivedRoutingTable()) != null && !queryRoutingTable.containsQuery(msgQuery)) continue;
            hostArray[i].queueMessageToSend(msgQuery);
        }
    }

    public void forwardPing(MsgPing msgPing, Host host) {
        Host[] hostArray;
        boolean bl = this.hostMgr.isShieldedLeafNode();
        if (bl && host != null && host.isLeafUltrapeerConnection()) {
            return;
        }
        if (!bl) {
            hostArray = this.hostsContainer.getUltrapeerConnections();
            this.forwardPing(msgPing, host, hostArray);
            hostArray = this.hostsContainer.getLeafConnections();
            this.forwardPing(msgPing, host, hostArray);
        }
        hostArray = this.hostsContainer.getPeerConnections();
        this.forwardPing(msgPing, host, hostArray);
    }

    private void forwardPing(MsgPing msgPing, Host host, Host[] hostArray) {
        for (int i = 0; i < hostArray.length; ++i) {
            if (hostArray[i] == host) continue;
            hostArray[i].queueMessageToSend(msgPing);
        }
    }

    public void pingHost(Host host) {
        this.pingHost(host, (byte)1);
    }

    public void pingHost(Host host, byte by) {
        MsgPing msgPing = new MsgPing();
        msgPing.getHeader().setTTL(by);
        this.checkAndAddToPingRoutingTable(msgPing.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
            NLogger.debug("OUTGOING_MESSAGES", "Queueing Ping: " + msgPing.getDebugString() + " - " + msgPing.getHeader().getDebugString() + " - Host: " + host.toString());
        }
        host.queueMessageToSend(msgPing);
    }

    public void requestTCPConnectBack() {
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        TCPConnectBackVMsg tCPConnectBackVMsg = new TCPConnectBackVMsg(hostAddress.getPort());
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        int n = 0;
        for (int i = 0; n <= 3 && i < hostArray.length; ++i) {
            if (!hostArray[i].isTCPConnectBackSupported()) continue;
            hostArray[i].queueMessageToSend(tCPConnectBackVMsg);
            ++n;
        }
    }

    public void updateLocalQueryRoutingTable() {
        this.lastSentQueryRoutingTable = QueryRoutingTable.createLocalQueryRoutingTable();
    }

    private class QRPUpdateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private QRPUpdateTimer() {
        }

        public void run() {
            try {
                this.sendQueryRoutingTable();
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }

        private void sendQueryRoutingTable() {
            boolean bl = MsgManager.this.hostMgr.isUltrapeer();
            if (!MsgManager.this.hostMgr.isShieldedLeafNode() && !bl) {
                return;
            }
            Host[] hostArray = MsgManager.this.hostsContainer.getUltrapeerConnections();
            QueryRoutingTable queryRoutingTable = null;
            for (int i = 0; i < hostArray.length; ++i) {
                if ((!bl ? !hostArray[i].isQueryRoutingSupported() : !hostArray[i].isUPQueryRoutingSupported()) || !hostArray[i].isQRTableUpdateRequired()) continue;
                Logger.logMessage(Logger.FINER, (short)16, "Updating QRTable for: " + hostArray[i]);
                if (queryRoutingTable == null) {
                    MsgManager.this.updateLocalQueryRoutingTable();
                    queryRoutingTable = MsgManager.this.lastSentQueryRoutingTable;
                }
                QueryRoutingTable queryRoutingTable2 = hostArray[i].getLastSentRoutingTable();
                Iterator iterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator(queryRoutingTable, queryRoutingTable2);
                while (iterator.hasNext()) {
                    RouteTableUpdateMsg routeTableUpdateMsg = (RouteTableUpdateMsg)iterator.next();
                    hostArray[i].queueMessageToSend(routeTableUpdateMsg);
                }
                hostArray[i].setLastSentRoutingTable(queryRoutingTable);
            }
        }
    }
}

