/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.common.IntObj;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class MsgPong
extends Message {
    private static final byte[] GGEP_VENDOR_CODE = new byte[5];
    private byte[] body;
    private int port;
    private byte[] ip;
    private long fileCount;
    private long fileSizeInKB;
    private int avgDailyUptime;

    public MsgPong(MsgHeader msgHeader, byte[] byArray) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)1);
        this.body = byArray;
        this.getHeader().setDataLen(this.body.length);
        this.avgDailyUptime = -1;
        this.parseBody();
    }

    public MsgPong(MsgHeader msgHeader, byte[] byArray, int n, int n2, int n3) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)1);
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Can't accept ip that is not 4 bytes in length: " + byArray.length);
        }
        this.ip = byArray;
        this.port = n;
        this.fileCount = n2;
        StatisticsManager statisticsManager = StatisticsManager.getInstance();
        StatisticProvider statisticProvider = statisticsManager.getStatisticProvider("DailyUptimeProvider");
        this.avgDailyUptime = ((IntObj)statisticProvider.getValue()).intValue();
        boolean bl = HostManager.getInstance().isUltrapeer();
        this.fileSizeInKB = bl ? (long)MsgPong.createUltrapeerMarking(n3) : (long)n3;
        this.buildBody();
        this.getHeader().setDataLen(this.body.length);
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getIP() {
        return this.ip;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getFileSizeInKB() {
        return this.fileSizeInKB;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    public String getDebugString() {
        return "Pong[ IP=" + IPUtils.ip2string(this.ip) + ", Port=" + this.port + ", FileCount=" + this.fileCount + ", FileSize=" + this.fileSizeInKB + ", AvgUptime=" + this.avgDailyUptime + ", HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }

    private void buildBody() {
        int n;
        byte[] byArray;
        HostManager hostManager;
        GGEPBlock gGEPBlock = new GGEPBlock();
        if (this.avgDailyUptime > 0) {
            gGEPBlock.addExtension("DU", this.avgDailyUptime);
        }
        if ((hostManager = HostManager.getInstance()).isUltrapeer()) {
            byArray = new byte[3];
            byArray[0] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getUltrapeerMajorVersionNumber(), VersionUtils.getUltrapeerMinorVersionNumber());
            NetworkHostsContainer networkHostsContainer = hostManager.getNetworkHostsContainer();
            byArray[1] = (byte)networkHostsContainer.getOpenLeafSlotsCount();
            byArray[2] = (byte)networkHostsContainer.getOpenUltrapeerSlotsCount();
            gGEPBlock.addExtension("UP", byArray);
        }
        gGEPBlock.addExtension("VC", GGEP_VENDOR_CODE);
        try {
            byArray = gGEPBlock.getBytes();
            n = byArray.length;
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
            n = 0;
            byArray = null;
        }
        this.body = new byte[14 + n];
        IOUtil.serializeShortLE((short)this.port, this.body, 0);
        System.arraycopy(this.ip, 0, this.body, 2, 4);
        IOUtil.serializeIntLE((int)this.fileCount, this.body, 6);
        IOUtil.serializeIntLE((int)this.fileSizeInKB, this.body, 10);
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.body, 14, n);
        }
    }

    private void parseBody() {
        this.port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 0));
        this.ip = new byte[4];
        this.ip[0] = this.body[2];
        this.ip[1] = this.body[3];
        this.ip[2] = this.body[4];
        this.ip[3] = this.body[5];
        this.fileCount = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 6));
        this.fileSizeInKB = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 10));
        if (this.body.length <= 14) {
            return;
        }
        this.parseGGEPBlocks();
    }

    private void parseGGEPBlocks() {
        byte[] byArray;
        GGEPBlock[] gGEPBlockArray;
        try {
            gGEPBlockArray = GGEPBlock.parseGGEPBlocks(this.body, 14);
        }
        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
            Logger.logMessage(Logger.FINE, (short)16, invalidGGEPBlockException);
            return;
        }
        if (GGEPBlock.isExtensionHeaderInBlocks(gGEPBlockArray, "DU") && (byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "DU")) != null) {
            try {
                this.avgDailyUptime = IOUtil.deserializeIntLE(byArray, 0, byArray.length);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logWarning((short)16, numberFormatException, "Invalid average uptime GGEP extension data: " + HexConverter.toHexString(byArray));
                this.avgDailyUptime = -1;
            }
        }
    }

    public boolean isUltrapeerMarked() {
        if (this.fileSizeInKB < 8L) {
            return false;
        }
        return (this.fileSizeInKB & this.fileSizeInKB - 1L) == 0L;
    }

    private static int createUltrapeerMarking(int n) {
        if (n < 12) {
            return 8;
        }
        int n2 = IOUtil.determineBitCount(n);
        int n3 = (int)Math.pow(2.0, n2);
        int n4 = n3 - n3 / 4;
        if (n < n4) {
            n3 = (int)Math.pow(2.0, n2 - 1);
        }
        return n3;
    }

    static {
        MsgPong.GGEP_VENDOR_CODE[0] = 80;
        MsgPong.GGEP_VENDOR_CODE[1] = 72;
        MsgPong.GGEP_VENDOR_CODE[2] = 69;
        MsgPong.GGEP_VENDOR_CODE[3] = 88;
        MsgPong.GGEP_VENDOR_CODE[4] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getMajorVersionNumber(), VersionUtils.getMinorVersionNumber());
    }
}

