/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;

public class MsgQuery
extends Message {
    public static final boolean IS_PHEX_CAPABLE_OF_XML_RESULTS = false;
    private static final int MINSPEED_BITBASED_BIT = 15;
    private static final int MINSPEED_FIREWALL_BIT = 14;
    private static final int MINSPEED_XML_BIT = 13;
    private boolean minSpeedIsBitBased;
    private boolean requesterIsFirewalled;
    private boolean requesterIsXmlResultsCapable;
    private String searchString;
    private byte[] body;
    private boolean isParsed;
    private List queryURNList;

    public MsgQuery(byte by, String string, URN uRN, boolean bl, boolean bl2) {
        super(new MsgHeader(-128, by, 0));
        this.searchString = string;
        if (uRN != null) {
            this.queryURNList = new ArrayList(1);
            this.queryURNList.add(uRN);
        } else {
            this.queryURNList = Collections.EMPTY_LIST;
        }
        this.minSpeedIsBitBased = true;
        this.requesterIsFirewalled = bl2;
        this.requesterIsXmlResultsCapable = bl;
        this.buildBody();
        this.getHeader().setDataLen(this.body.length);
    }

    public MsgQuery(MsgHeader msgHeader, byte[] byArray) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)-128);
        this.body = byArray;
        this.parseBody();
    }

    public MsgQuery(MsgQuery msgQuery, byte by) {
        super(new MsgHeader(-128, 0));
        this.getHeader().copy(msgQuery.getHeader());
        this.getHeader().setTTL(by);
        this.body = msgQuery.body;
        this.searchString = msgQuery.searchString;
        this.minSpeedIsBitBased = msgQuery.minSpeedIsBitBased;
        this.requesterIsFirewalled = msgQuery.requesterIsFirewalled;
        this.requesterIsXmlResultsCapable = msgQuery.requesterIsXmlResultsCapable;
        this.isParsed = msgQuery.isParsed;
        this.queryURNList = new ArrayList(msgQuery.queryURNList);
    }

    private boolean isMinSpeedBitBased() {
        return this.minSpeedIsBitBased;
    }

    public boolean isRequesterFirewalled() {
        return this.minSpeedIsBitBased && this.requesterIsFirewalled;
    }

    public boolean isRequesterXmlResultsCapable() {
        return this.minSpeedIsBitBased && this.requesterIsXmlResultsCapable;
    }

    private void setMinSpeedIsBitBased(boolean bl) {
        this.minSpeedIsBitBased = bl;
    }

    private void setRequesterIsFirewalled(boolean bl) {
        this.requesterIsFirewalled = bl;
    }

    private void setRequesterIsXmlResultsCapable(boolean bl) {
        this.requesterIsXmlResultsCapable = bl;
    }

    private static boolean isBitSet(short s, int n) {
        int n2 = 1 << n;
        return (s & n2) != 0;
    }

    private static short setBit(short s, int n) {
        short s2 = (short)(1 << n);
        return (short)(s | s2);
    }

    private static short setBit(Short s, Integer n) {
        return MsgQuery.setBit((short)s, (int)n);
    }

    private static boolean isBitSet(Short s, Integer n) {
        return MsgQuery.isBitSet((short)s, (int)n);
    }

    public URN[] getQueryURNs() {
        URN[] uRNArray = new URN[this.queryURNList.size()];
        return this.queryURNList.toArray(uRNArray);
    }

    public boolean hasQueryURNs() {
        return !this.queryURNList.isEmpty();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[").append(this.getHeader()).append(", MinSpeedIsBitBased=").append(this.minSpeedIsBitBased);
        if (this.minSpeedIsBitBased) {
            stringBuffer.append(", RequesterIsFirewalled").append(this.requesterIsFirewalled).append(", RequesterIsXmlResultsCapable").append(this.requesterIsXmlResultsCapable);
        }
        stringBuffer.append(", SearchString=").append(this.searchString).append("]");
        return stringBuffer.toString();
    }

    private void buildBody() {
        int n = this.calculateBodySize();
        this.body = new byte[n];
        short s = this.buildComplexMinSpeed();
        IOUtil.serializeShort(s, this.body, 0);
        int n2 = IOUtil.serializeString(this.searchString, this.body, 2);
        this.body[n2++] = 0;
        if (this.queryURNList.size() == 0) {
            n2 = IOUtil.serializeString("urn:sha1", this.body, n2);
        } else {
            Iterator iterator = this.queryURNList.iterator();
            while (iterator.hasNext()) {
                URN uRN = (URN)iterator.next();
                n2 = IOUtil.serializeString(uRN.getAsString(), this.body, n2);
            }
        }
        this.body[n2++] = 0;
    }

    private int calculateBodySize() {
        int n = 2;
        n += this.searchString.length();
        n += 2;
        if (this.queryURNList.size() == 0) {
            n += 8;
        } else {
            Iterator iterator = this.queryURNList.iterator();
            while (iterator.hasNext()) {
                URN uRN = (URN)iterator.next();
                n += uRN.getAsString().length();
            }
        }
        return n;
    }

    private void parseBody() {
        int n = 0;
        short s = IOUtil.deserializeShort(this.body, n);
        this.parseMinSpeed(s);
        n += 2;
        StringBuffer stringBuffer = new StringBuffer();
        n = IOUtil.deserializeString(this.body, n, stringBuffer);
        if (n < this.body.length && this.body[n] == 0) {
            ++n;
        }
        this.searchString = stringBuffer.toString();
        stringBuffer.setLength(0);
        n = IOUtil.deserializeString(this.body, n, stringBuffer);
        String string = stringBuffer.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u001c");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!URN.isValidURN(string2)) continue;
            URN uRN = new URN(string2);
            if (this.queryURNList == null) {
                this.queryURNList = new ArrayList(stringTokenizer.countTokens());
            }
            this.queryURNList.add(uRN);
        }
        if (this.queryURNList == null) {
            this.queryURNList = Collections.EMPTY_LIST;
        }
    }

    private void parseMinSpeed(short s) {
        this.minSpeedIsBitBased = MsgQuery.isBitSet(s, 15);
        if (this.isMinSpeedBitBased()) {
            this.requesterIsFirewalled = MsgQuery.isBitSet(s, 14);
            this.requesterIsXmlResultsCapable = MsgQuery.isBitSet(s, 13);
        }
    }

    private short buildComplexMinSpeed() {
        short s = 0;
        if (this.minSpeedIsBitBased) {
            s = MsgQuery.setBit(s, 15);
            if (this.requesterIsFirewalled) {
                s = MsgQuery.setBit(s, 14);
            }
            if (this.requesterIsXmlResultsCapable) {
                s = MsgQuery.setBit(s, 13);
            }
        }
        return s;
    }
}

