/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.GUID;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseRecord;
import phex.query.QueryConstants;
import phex.upload.UploadManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.xml.XMLUtils;

public class MsgQueryResponse
extends Message
implements QueryConstants {
    private static final boolean INCLUDE_QHD = true;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_SUPPORTED_MASK = 1;
    private byte[] body;
    private QueryResponseRecord[] records;
    private int remoteHostSpeed;
    private HostAddress hostAddress;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isChatSupported;
    private boolean isBrowseHostSupported;
    private HostAddress[] pushProxyAddresses;
    private boolean isParsed;

    public MsgQueryResponse(MsgHeader msgHeader, GUID gUID, HostAddress hostAddress, int n, QueryResponseRecord[] queryResponseRecordArray) throws UnknownHostException {
        super(msgHeader);
        boolean bl;
        if (queryResponseRecordArray.length > 255) {
            throw new IllegalArgumentException("A maximum of 255 records can be associated with a single response: " + queryResponseRecordArray.length);
        }
        this.getHeader().setPayloadType((byte)-127);
        this.remoteClientID = gUID;
        this.hostAddress = hostAddress;
        this.remoteHostSpeed = n;
        this.records = queryResponseRecordArray;
        this.pushProxyAddresses = HostManager.getInstance().getNetworkHostsContainer().getPushProxies();
        if (NetworkManager.getInstance().hasConnectedIncoming()) {
            bl = false;
            this.pushNeededFlag = 0;
        } else {
            bl = true;
            this.pushNeededFlag = 1;
        }
        boolean bl2 = UploadManager.getInstance().isHostBusy();
        try {
            this.buildBody(bl, bl2);
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        this.getHeader().setDataLen(this.body.length);
        this.isParsed = true;
    }

    public MsgQueryResponse(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)-127);
        this.body = byArray;
        msgHeader.setDataLen(this.body.length);
        int n = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 1));
        if (!HostAddress.isPortInRange(n)) {
            throw new InvalidMessageException("Port out of range: " + n);
        }
        this.hostAddress = new HostAddress(this.getHostIP(), n);
        this.isParsed = false;
    }

    private void buildBody(boolean bl, boolean bl2) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.records.length;
        byteArrayOutputStream.write((byte)n2);
        IOUtil.serializeShortLE((short)this.hostAddress.getPort(), byteArrayOutputStream);
        byte[] byArray = this.hostAddress.getHostIP();
        byteArrayOutputStream.write(byArray);
        IOUtil.serializeIntLE(this.remoteHostSpeed, byteArrayOutputStream);
        for (n = 0; n < n2; ++n) {
            this.records[n].write(byteArrayOutputStream);
        }
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write(72);
        byteArrayOutputStream.write(69);
        byteArrayOutputStream.write(88);
        byteArrayOutputStream.write(2);
        n = 0;
        if (bl) {
            n = 1;
        }
        int n3 = 0;
        if (bl2) {
            n3 = 4;
        }
        int n4 = 0;
        if (ServiceManager.sCfg.mShareBrowseDir || this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
            n4 = 32;
        }
        byteArrayOutputStream.write((byte)(n | 4 | 0 | 0x10 | 0x20));
        byteArrayOutputStream.write((byte)(1 | n3 | 0 | 0 | n4));
        if (ServiceManager.sCfg.isChatEnabled) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byte[] byArray2 = GGEPBlock.getQueryReplyGGEPBlock(ServiceManager.sCfg.mShareBrowseDir, this.pushProxyAddresses);
        if (byArray2.length > 0) {
            byteArrayOutputStream.write(byArray2);
        }
        this.remoteClientID.write(byteArrayOutputStream);
        this.body = byteArrayOutputStream.toByteArray();
    }

    public short getRecordCount() {
        return (short)IOUtil.unsignedByte2int(this.body[0]);
    }

    public byte[] getHostIP() {
        byte[] byArray = new byte[]{this.body[3], this.body[4], this.body[5], this.body[6]};
        return byArray;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public int getRemoteHostSpeed() {
        this.parseBody();
        return this.remoteHostSpeed;
    }

    public String getVendorCode() {
        this.parseBody();
        return this.vendorCode;
    }

    public short getPushNeededFlag() {
        this.parseBody();
        return this.pushNeededFlag;
    }

    public short getServerBusyFlag() {
        this.parseBody();
        return this.serverBusyFlag;
    }

    public short getHasUploadedFlag() {
        this.parseBody();
        return this.hasUploadedFlag;
    }

    public short getUploadSpeedFlag() {
        this.parseBody();
        return this.uploadSpeedFlag;
    }

    public boolean isChatSupported() {
        this.parseBody();
        return this.isChatSupported;
    }

    public boolean isBrowseHostSupported() {
        this.parseBody();
        return this.isBrowseHostSupported;
    }

    public HostAddress[] getPushProxyAddresses() {
        this.parseBody();
        return this.pushProxyAddresses;
    }

    public GUID getRemoteClientID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public QueryResponseRecord getMsgRecord(int n) {
        this.parseBody();
        return this.records[n];
    }

    public void copy(MsgQueryResponse msgQueryResponse) {
        this.getHeader().copy(msgQueryResponse.getHeader());
        this.hostAddress = msgQueryResponse.hostAddress;
        this.remoteHostSpeed = msgQueryResponse.remoteHostSpeed;
        this.remoteClientID = msgQueryResponse.remoteClientID;
        int n = msgQueryResponse.records.length;
        this.records = new QueryResponseRecord[n];
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord = new QueryResponseRecord();
            queryResponseRecord.copy(msgQueryResponse.records[i]);
            this.records[i] = queryResponseRecord;
        }
        this.body = msgQueryResponse.body;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    private void parseBody() {
        int n;
        if (this.isParsed) {
            return;
        }
        int n2 = 0;
        int n3 = (n = this.body[n2++]) < 0 ? 256 + n : n;
        n2 += 2;
        n2 += 4;
        try {
            int n4;
            int n5 = IOUtil.deserializeIntLE(this.body, n2);
            if (n5 < 0) {
                n5 = Integer.MAX_VALUE;
            }
            this.remoteHostSpeed = n5;
            n2 += 4;
            this.records = new QueryResponseRecord[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                QueryResponseRecord queryResponseRecord = new QueryResponseRecord();
                n2 = queryResponseRecord.deserialize(this.body, n2);
                this.records[n4] = queryResponseRecord;
            }
            this.pushNeededFlag = (short)-1;
            this.serverBusyFlag = (short)-1;
            this.hasUploadedFlag = (short)-1;
            this.uploadSpeedFlag = (short)-1;
            this.isBrowseHostSupported = false;
            if (n2 <= this.getHeader().getDataLen() - 16 - 4 - 2) {
                int n6;
                byte by;
                this.vendorCode = new String(this.body, n2, 4, "ISO-8859-1");
                if (!this.isVendorCodeValid(this.vendorCode)) {
                    String string = HexConverter.toHexString(this.body, n2, 4);
                    Logger.logMessage(Logger.WARNING, (short)16, this.getHeader().getFromHost(), (Object)("Illegal QHD vendor code found: " + this.vendorCode + " (" + string + "). Body: " + HexConverter.toHexString(this.body)));
                    this.vendorCode = string;
                }
                n4 = IOUtil.unsignedByte2int(this.body[n2 += 4]);
                ++n2;
                if (n4 > 1) {
                    byte by2 = this.body[n2];
                    by = this.body[n2 + 1];
                    if ((by & 1) != 0) {
                        this.pushNeededFlag = (by2 & 1) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 4) != 0) {
                        this.serverBusyFlag = (by & 4) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 8) != 0) {
                        this.hasUploadedFlag = (by & 8) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 0x10) != 0) {
                        this.uploadSpeedFlag = (by & 0x10) != 0 ? (short)1 : 0;
                    }
                    if ((by2 & 0x20) != 0 && (by & 0x20) != 0) {
                        int n7;
                        for (n7 = n2 + 2; n7 < this.body.length && this.body[n7] != -61; ++n7) {
                        }
                        GGEPBlock[] gGEPBlockArray = null;
                        try {
                            gGEPBlockArray = GGEPBlock.parseGGEPBlocks(this.body, n7);
                            this.isBrowseHostSupported = GGEPBlock.isExtensionHeaderInBlocks(gGEPBlockArray, "BH");
                            this.pushProxyAddresses = GGEPExtension.parsePushProxyExtensionData(gGEPBlockArray);
                        }
                        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
                            Logger.logMessage(Logger.FINE, (short)16, invalidGGEPBlockException);
                        }
                    }
                }
                if ((n6 = this.body.length - (n2 += n4) - 16) > 0 && (this.vendorCode.equals("LIME") || this.vendorCode.equals("RAZA") || this.vendorCode.equals("PHEX"))) {
                    by = this.body[n2];
                    this.isChatSupported = (by & 1) != 0;
                }
            }
            this.parseRemoteClientID();
            this.isParsed = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.getHeader().getDataLen() - 16);
    }

    private boolean isVendorCodeValid(String string) {
        if (string.length() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (XMLUtils.isXmlChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

