/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.RouteTableUpdateMsg;
import phex.utils.GnutellaOutputStream;

public class QRPatchTableMsg
extends RouteTableUpdateMsg {
    public static final byte COMPRESSOR_NONE = 0;
    public static final byte COMPRESSOR_ZLIB = 1;
    public static final int MAX_MESSAGE_DATA_SIZE = 4096;
    private byte sequenceNumber;
    private byte sequenceSize;
    private byte compressor;
    private byte entryBits;
    private byte[] data;
    private int dataOffset;
    private int dataLength;

    public QRPatchTableMsg(byte by, byte by2, byte by3, byte by4, byte[] byArray, int n, int n2) {
        super((byte)1, 5 + n2);
        this.sequenceNumber = by;
        this.sequenceSize = by2;
        this.compressor = by3;
        this.entryBits = by4;
        this.data = byArray;
        this.dataOffset = n;
        this.dataLength = n2;
    }

    public QRPatchTableMsg(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        super((byte)1, msgHeader);
        msgHeader.setDataLen(byArray.length);
        this.sequenceNumber = byArray[1];
        this.sequenceSize = byArray[2];
        if (this.sequenceNumber == 0 || this.sequenceSize == 0 || this.sequenceNumber > this.sequenceSize) {
            throw new InvalidMessageException("Invalid sequence number or size: " + this.sequenceNumber + "/" + this.sequenceSize);
        }
        this.compressor = byArray[3];
        if (this.compressor != 0 && this.compressor != 1) {
            throw new InvalidMessageException("Invalid compressor type: " + this.compressor);
        }
        this.entryBits = byArray[4];
        this.dataOffset = 0;
        this.dataLength = byArray.length - 5;
        this.data = new byte[this.dataLength];
        System.arraycopy(byArray, 5, this.data, 0, this.dataLength);
    }

    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte getSequenceSize() {
        return this.sequenceSize;
    }

    public byte getCompressor() {
        return this.compressor;
    }

    public byte getEntryBits() {
        return this.entryBits;
    }

    public byte[] getPatchData() {
        return this.data;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        super.writeMessage(gnutellaOutputStream);
        gnutellaOutputStream.write(this.sequenceNumber);
        gnutellaOutputStream.write(this.sequenceSize);
        gnutellaOutputStream.write(this.compressor);
        gnutellaOutputStream.write(this.entryBits);
        gnutellaOutputStream.write(this.data, this.dataOffset, this.dataLength);
    }
}

