/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;
import phex.utils.GnutellaOutputStream;

public abstract class RouteTableUpdateMsg
extends Message {
    public static final byte RESET_TABLE_VARIANT = 0;
    public static final byte PATCH_TABLE_VARIANT = 1;
    private byte variant;

    public RouteTableUpdateMsg(byte by, int n) {
        super(new MsgHeader(48, 1, n));
        this.variant = by;
    }

    public RouteTableUpdateMsg(byte by, MsgHeader msgHeader) {
        super(msgHeader);
        this.variant = by;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.variant);
    }

    public byte getVariant() {
        return this.variant;
    }

    public static RouteTableUpdateMsg parseMessage(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        byte by = byArray[0];
        switch (by) {
            case 0: {
                return new QRResetTableMsg(msgHeader, byArray);
            }
            case 1: {
                return new QRPatchTableMsg(msgHeader, byArray);
            }
        }
        throw new InvalidMessageException("Unknown RouteTableUpdateMsg variant");
    }
}

