/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class MessagesSupportedVMsg
extends VendorMsg {
    private static final int VERSION = 0;
    private static MessagesSupportedVMsg myMessagesSupportedVMsg;
    private HashSet supportedMessages = new HashSet();

    public MessagesSupportedVMsg(MsgHeader msgHeader, byte[] byArray, int n, int n2, byte[] byArray2) throws InvalidMessageException {
        super(msgHeader, byArray, n, n2, byArray2);
        if (n2 > 0) {
            throw new InvalidMessageException("Vendor Message 'MessagesSupported' with invalid version: " + n2);
        }
        if ((byArray2.length - 2) % 8 != 0) {
            throw new InvalidMessageException("Vendor Message 'MessagesSupported' invalid data length: " + byArray2.length);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, byArray2.length);
        try {
            int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byteArrayInputStream));
            byte[] byArray3 = new byte[8];
            for (int i = 0; i < n3; ++i) {
                byteArrayInputStream.read(byArray3);
                SupportedMessage supportedMessage = new SupportedMessage(byArray3);
                this.supportedMessages.add(supportedMessage);
            }
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
            throw new InvalidMessageException(iOException.getMessage());
        }
    }

    private MessagesSupportedVMsg() {
        super(VENDORID_NULL, 0, 0, IOUtil.EMPTY_BYTE_ARRAY);
        this.createSupportedMsgData();
    }

    public static MessagesSupportedVMsg getMyMsgSupported() {
        if (myMessagesSupportedVMsg == null) {
            myMessagesSupportedVMsg = new MessagesSupportedVMsg();
        }
        return myMessagesSupportedVMsg;
    }

    public boolean isVendorMessageSupported(byte[] byArray, int n) {
        Iterator iterator = this.supportedMessages.iterator();
        while (iterator.hasNext()) {
            SupportedMessage supportedMessage = (SupportedMessage)iterator.next();
            if (!Arrays.equals(byArray, supportedMessage.getVendorId()) || n != supportedMessage.getSubSelector()) continue;
            return true;
        }
        return false;
    }

    public boolean isTCPConnectBackSupported() {
        return this.isVendorMessageSupported(VENDORID_BEAR, 7);
    }

    public boolean isPushProxySupported() {
        return this.isVendorMessageSupported(VENDORID_LIME, 21);
    }

    private void createSupportedMsgData() {
        SupportedMessage supportedMessage = null;
        supportedMessage = new SupportedMessage(VENDORID_BEAR, 7, 1);
        this.supportedMessages.add(supportedMessage);
        supportedMessage = new SupportedMessage(VENDORID_LIME, 21, 2);
        this.supportedMessages.add(supportedMessage);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtil.serializeShortLE((short)this.supportedMessages.size(), byteArrayOutputStream);
            Iterator iterator = this.supportedMessages.iterator();
            while (iterator.hasNext()) {
                supportedMessage = (SupportedMessage)iterator.next();
                supportedMessage.serialize(byteArrayOutputStream);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.setVenderMsgData(byArray);
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    class SupportedMessage {
        private byte[] vendorId;
        private int subSelector;
        private int version;
        private int hashCode = -1;

        public SupportedMessage(byte[] byArray) {
            this.vendorId = new byte[4];
            System.arraycopy(byArray, 0, this.vendorId, 0, 4);
            this.subSelector = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, 4));
            this.version = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, 6));
        }

        public SupportedMessage(byte[] byArray, int n, int n2) {
            this.vendorId = byArray;
            this.subSelector = n;
            this.version = n2;
        }

        public void serialize(OutputStream outputStream) throws IOException {
            outputStream.write(this.vendorId);
            IOUtil.serializeShortLE((short)this.subSelector, outputStream);
            IOUtil.serializeShortLE((short)this.version, outputStream);
        }

        public int getSubSelector() {
            return this.subSelector;
        }

        public byte[] getVendorId() {
            return this.vendorId;
        }

        public int getVersion() {
            return this.version;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int n = 0;
                int n2 = 0xFF & this.vendorId[0] | 0xFF00 & this.vendorId[1] << 8 | 0xFF0000 & this.vendorId[2] << 16 | this.vendorId[3] << 24;
                n = 31 * n + (n2 ^ n2 >> 32);
                n = 31 * n + (this.subSelector ^ this.subSelector >> 32);
                this.hashCode = n = 31 * n + (this.version ^ this.version >> 32);
            }
            return this.hashCode;
        }
    }
}

