/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.security.PhexSecurityManager;
import phex.utils.NLogger;

public class NIOServer
extends Server {
    private ServerSocketChannel listeningChannel;
    private Selector selector;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        if (NLogger.isDebugEnabled("SERVER")) {
            NLogger.debug("SERVER", "Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort());
        }
        try {
            while (this.selector.isOpen()) {
                this.selector.select(10000L);
                if (this.selector.isOpen()) {
                    object = this.selector.selectedKeys().iterator();
                    while (object.hasNext()) {
                        SelectionKey selectionKey = (SelectionKey)object.next();
                        object.remove();
                        if (!selectionKey.isAcceptable()) continue;
                        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                        try {
                            SocketChannel socketChannel = serverSocketChannel.accept();
                            this.handleIncomingClientChannel(socketChannel);
                        }
                        catch (IOException iOException) {
                            NLogger.debug("SERVER", iOException, iOException);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            NLogger.error("SERVER", exception, exception);
        }
        this.isRunning = false;
        NLogger.debug("SERVER", "Listener stopped.");
        NetworkManager.getInstance().updateLocalAddress(HostAddress.LOCAL_HOST_IP, 6346);
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void handleIncomingClientChannel(SocketChannel socketChannel) throws IOException {
        socketChannel.configureBlocking(true);
        Socket socket = socketChannel.socket();
        socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        HostAddress hostAddress = new HostAddress(socket.getInetAddress().getAddress(), socket.getPort());
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        if (!networkHostsContainer.isConnectedToHost(hostAddress) && !hostAddress.isPrivateIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        byte by = PhexSecurityManager.getInstance().controlHostAddressAccess(hostAddress);
        switch (by) {
            case 2: 
            case 3: {
                throw new IOException("Host access denied: " + socket.getInetAddress().getHostAddress());
            }
        }
        NLogger.debug("SERVER", "Accepted incoming connection from: " + hostAddress.getFullHostName());
        IncomingConnectionDispatcher incomingConnectionDispatcher = new IncomingConnectionDispatcher(socket);
        ThreadPool.getInstance().addJob(incomingConnectionDispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind() throws IOException {
        boolean bl;
        if (!$assertionsDisabled && this.listeningChannel != null) {
            throw new AssertionError();
        }
        int n = ServiceManager.sCfg.mListeningPort;
        this.listeningChannel = ServerSocketChannel.open();
        this.serverSocket = this.listeningChannel.socket();
        this.listeningChannel.configureBlocking(false);
        int n2 = 0;
        do {
            bl = false;
            try {
                NLogger.debug("SERVER", "Binding to port " + n);
                this.serverSocket.bind(new InetSocketAddress(n));
            }
            catch (BindException bindException) {
                NLogger.debug("SERVER", "Binding failed to port " + n);
                if (n2 > 10) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        if (ServiceManager.sCfg.mMyIP.length() > 0) {
            NetworkManager.getInstance().setForcedHostIP(HostAddress.parseIP(ServiceManager.sCfg.mMyIP));
        } else {
            byte[] byArray = this.resolveLocalHostIP();
            n = this.serverSocket.getLocalPort();
            NetworkManager.getInstance().updateLocalAddress(byArray, n);
        }
        this.selector = Selector.open();
        this.listeningChannel.register(this.selector, 16);
    }

    protected void closeServer() {
        try {
            this.listeningChannel.close();
            SelectionKey selectionKey = this.listeningChannel.keyFor(this.selector);
            selectionKey.cancel();
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.listeningChannel = null;
    }

    static {
        $assertionsDisabled = !NIOServer.class.desiredAssertionStatus();
    }
}

