/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.security.PhexSecurityManager;
import phex.utils.NLogger;

public class OIOServer
extends Server {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        if (NLogger.isDebugEnabled("SERVER")) {
            NLogger.debug("SERVER", "Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort());
        }
        try {
            while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    object = this.serverSocket.accept();
                    this.handleIncomingSocket((Socket)object);
                }
                catch (SocketException socketException) {
                    NLogger.debug("SERVER", socketException);
                }
                catch (IOException iOException) {
                    NLogger.error("SERVER", iOException, iOException);
                }
            }
        }
        catch (Exception exception) {
            NLogger.error("SERVER", exception, exception);
        }
        this.isRunning = false;
        NLogger.debug("SERVER", "Listener stopped.");
        NetworkManager.getInstance().updateLocalAddress(HostAddress.LOCAL_HOST_IP, 6346);
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void handleIncomingSocket(Socket socket) throws IOException {
        socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        HostAddress hostAddress = new HostAddress(socket.getInetAddress().getAddress(), socket.getPort());
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        if (!networkHostsContainer.isConnectedToHost(hostAddress) && !hostAddress.isPrivateIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        byte by = PhexSecurityManager.getInstance().controlHostAddressAccess(hostAddress);
        switch (by) {
            case 2: 
            case 3: {
                throw new IOException("Host access denied: " + socket.getInetAddress().getHostAddress());
            }
        }
        NLogger.debug("SERVER", "Accepted incoming connection from: " + hostAddress.getFullHostName());
        IncomingConnectionDispatcher incomingConnectionDispatcher = new IncomingConnectionDispatcher(socket);
        ThreadPool.getInstance().addJob(incomingConnectionDispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind() throws IOException {
        boolean bl;
        if (!$assertionsDisabled && this.serverSocket != null) {
            throw new AssertionError();
        }
        int n = ServiceManager.sCfg.mListeningPort;
        this.serverSocket = new ServerSocket();
        int n2 = 0;
        do {
            bl = false;
            try {
                NLogger.debug("SERVER", "Binding to port " + n);
                this.serverSocket.bind(new InetSocketAddress(n));
            }
            catch (BindException bindException) {
                NLogger.debug("SERVER", "Binding failed to port " + n);
                if (n2 > 10) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        if (ServiceManager.sCfg.mMyIP.length() > 0) {
            NetworkManager.getInstance().setForcedHostIP(HostAddress.parseIP(ServiceManager.sCfg.mMyIP));
        } else {
            byte[] byArray = this.resolveLocalHostIP();
            n = this.serverSocket.getLocalPort();
            NetworkManager.getInstance().updateLocalAddress(byArray, n);
        }
    }

    protected synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }

    static {
        $assertionsDisabled = !OIOServer.class.desiredAssertionStatus();
    }
}

