/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.NLogger;

public class OnlineObserver {
    private int failedConnections = 0;

    public void markFailedConnection() {
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        if (networkHostsContainer.getTotalConnectionCount() > 0) {
            this.failedConnections = 0;
            return;
        }
        ++this.failedConnections;
        if (NLogger.isDebugEnabled("ONLINE_OBSERVER") && this.failedConnections % 5 == 0) {
            NLogger.debug("ONLINE_OBSERVER", "Observed " + this.failedConnections + " failed connections.");
        }
        if (this.failedConnections > ServiceManager.sCfg.offlineConnectionFailureCount) {
            NLogger.debug("ONLINE_OBSERVER", "Too many connections failed.. disconnecting network.");
            NetworkManager.getInstance().disconnectNetwork();
        }
    }

    public void markSuccessfulConnection() {
        this.failedConnections = 0;
    }
}

