/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.utils.Logger;
import phex.utils.NLogger;

public abstract class Server
implements Runnable {
    protected ServerSocket serverSocket;
    protected boolean isRunning = false;
    protected boolean hasConnectedIncomming = false;
    protected long lastInConnectionTime = -1L;
    protected long lastFirewallCheckTime;

    public Server() {
        Environment.getInstance().scheduleTimerTask(new FirewallCheckTimer(), 300000L, 300000L);
    }

    public synchronized void startup() throws IOException {
        if (this.isRunning) {
            return;
        }
        NLogger.debug("SERVER", "Starting listener");
        this.isRunning = true;
        this.bind();
        ThreadPool.getInstance().addJob(this, "IncommingListener-" + Integer.toHexString(this.hashCode()));
    }

    protected abstract void bind() throws IOException;

    protected abstract void closeServer();

    public synchronized void restart() throws IOException {
        this.shutdown(true);
        this.startup();
    }

    public synchronized void shutdown(boolean bl) {
        if (!this.isRunning) {
            return;
        }
        NLogger.debug("SERVER", "Shutting down listener");
        this.closeServer();
        if (bl) {
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean getRunning() {
        return this.isRunning;
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    public byte[] resolveLocalHostIP() {
        byte[] byArray = null;
        InetAddress inetAddress = this.serverSocket.getInetAddress();
        byArray = inetAddress.getAddress();
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            byArray = HostAddress.LOCAL_HOST_IP;
        }
        return byArray;
    }

    public int getListeningLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    public void resetFirewallCheck() {
        this.lastFirewallCheckTime = 0L;
    }

    private class IncommingCheckRunner
    extends TimerTask {
        public static final long TIMER_PERIOD = 45000L;

        private IncommingCheckRunner() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            if (l - Server.this.lastInConnectionTime > 45000L) {
                Server.this.hasConnectedIncomming = false;
            }
        }
    }

    private class FirewallCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 300000L;
        private static final long CHECK_TIME = 900000L;

        private FirewallCheckTimer() {
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                if (Server.this.hasConnectedIncomming && l - Server.this.lastInConnectionTime > 900000L || !Server.this.hasConnectedIncomming && l - Server.this.lastFirewallCheckTime > 900000L) {
                    NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
                    if (networkHostsContainer.getUltrapeerConnectionCount() <= 2) {
                        return;
                    }
                    Server.this.lastFirewallCheckTime = l;
                    MsgManager.getInstance().requestTCPConnectBack();
                    Environment.getInstance().scheduleTimerTask(new IncommingCheckRunner(), 45000L);
                }
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }
}

