/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.util.ArrayList;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.connection.BrowseHostConnection;
import phex.connection.BrowseHostException;
import phex.download.RemoteFile;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.msg.MsgQueryResponse;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.Localizer;
import phex.utils.Logger;

public class BrowseHostResults
extends Search {
    public static final short NO_ERROR = 0;
    public static final short CONNECTION_ERROR = 1;
    public static final short BROWSE_HOST_ERROR = 2;
    private short browseHostError;
    private HostAddress hostAddress;
    private GUID hostGUID;

    public BrowseHostResults(HostAddress hostAddress, GUID gUID) {
        super(Localizer.getFormatedString("BrowsingHost", new Object[]{hostAddress.getFullHostName()}));
        this.hostAddress = hostAddress;
        this.hostGUID = gUID;
    }

    public void startSearching() {
        this.isSearching = true;
        this.browseHostError = 0;
        Runnable runnable = new Runnable(){

            public void run() {
                BrowseHostConnection browseHostConnection = new BrowseHostConnection(BrowseHostResults.this.hostAddress, BrowseHostResults.this.hostGUID, BrowseHostResults.this);
                try {
                    browseHostConnection.sendBrowseHostRequest();
                }
                catch (BrowseHostException browseHostException) {
                    Logger.logMessage(Logger.FINEST, (short)8, browseHostException);
                    BrowseHostResults.this.browseHostError = (short)2;
                    BrowseHostResults.this.stopSearching();
                }
                catch (IOException iOException) {
                    Logger.logMessage(Logger.FINEST, (short)8, iOException);
                    BrowseHostResults.this.browseHostError = (short)1;
                    BrowseHostResults.this.stopSearching();
                }
            }
        };
        ThreadPool.getInstance().addJob(runnable, "BrowseHostConnection-" + Integer.toHexString(runnable.hashCode()));
        this.fireSearchStarted();
    }

    public short getBrowseHostError() {
        return this.browseHostError;
    }

    public void stopSearching() {
        this.isSearching = false;
        this.fireSearchStoped();
    }

    public int getProgress() {
        if (!this.isSearching) {
            return 100;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void processResponse(MsgQueryResponse msgQueryResponse) {
        Object[] objectArray;
        int n;
        int n2 = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n2);
        queryHitHost.setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
        queryHitHost.setQueryResponseFields(msgQueryResponse);
        short s = queryHitHost.getHostRating();
        int n3 = this.queryHitList.size();
        int n4 = msgQueryResponse.getRecordCount();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(n4);
        for (n = 0; n < n4; ++n) {
            QueryResponseRecord queryResponseRecord = msgQueryResponse.getMsgRecord(n);
            objectArray = this.filteredQueryHitList;
            // MONITORENTER : this.filteredQueryHitList
            boolean bl = false;
            if (this.searchFilter != null) {
                bl = this.searchFilter.isFiltered(queryResponseRecord.getFileSize(), queryResponseRecord.getFilename(), n2, s);
            }
            if (bl) {
                // MONITOREXIT : objectArray
                continue;
            }
            String string = queryResponseRecord.getFilename();
            String string2 = queryResponseRecord.getPathInfo();
            long l = queryResponseRecord.getFileSize();
            URN uRN = queryResponseRecord.getURN();
            int n5 = queryResponseRecord.getFileIndex();
            RemoteFile remoteFile = new RemoteFile(queryHitHost, n5, string, string2, l, uRN, queryResponseRecord.getMetaData(), 100);
            this.queryHitList.add(remoteFile);
            if (!bl) {
                this.filteredQueryHitList.add(remoteFile);
            }
            arrayList.add(remoteFile);
            // MONITOREXIT : objectArray
        }
        n = this.queryHitList.size();
        if (n <= n3) {
            if (arrayList.size() <= 0) return;
        }
        objectArray = arrayList.toArray();
        this.fireSearchHitsAdded(n3, n, objectArray);
    }
}

