/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.host.Host;
import phex.query.DynamicQueryEngine;
import phex.utils.Logger;

public class DynamicQueryWorker
implements Runnable {
    private static final int WORKER_SLEEP_TIME = 500;
    private List queryList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicQueryEngine(DynamicQueryEngine dynamicQueryEngine) {
        List list = this.queryList;
        synchronized (list) {
            this.queryList.add(dynamicQueryEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicQuerysForHost(Host host) {
        ArrayList<DynamicQueryEngine> arrayList = new ArrayList<DynamicQueryEngine>();
        List list = this.queryList;
        synchronized (list) {
            Iterator iterator = this.queryList.iterator();
            while (iterator.hasNext()) {
                DynamicQueryEngine dynamicQueryEngine = (DynamicQueryEngine)iterator.next();
                if (dynamicQueryEngine.getFromHost() != host) continue;
                arrayList.add(dynamicQueryEngine);
            }
            this.queryList.removeAll(arrayList);
        }
    }

    public void startQueryWorker() {
        Thread thread = new Thread((Runnable)this, "DynamicQueryWorker-" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                this.processQueryList();
                continue;
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueryList() {
        DynamicQueryEngine[] dynamicQueryEngineArray;
        List list = this.queryList;
        synchronized (list) {
            int n = this.queryList.size();
            if (n == 0) {
                return;
            }
            dynamicQueryEngineArray = new DynamicQueryEngine[n];
            this.queryList.toArray(dynamicQueryEngineArray);
        }
        for (int i = 0; i < dynamicQueryEngineArray.length; ++i) {
            if (dynamicQueryEngineArray[i].isQueryFinished()) {
                List list2 = this.queryList;
                synchronized (list2) {
                    this.queryList.remove(dynamicQueryEngineArray[i]);
                    continue;
                }
            }
            dynamicQueryEngineArray[i].processQuery();
        }
    }
}

