/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.msg.MsgQueryResponse;
import phex.query.QueryConstants;
import phex.utils.VendorCodes;

public class QueryHitHost
implements QueryConstants {
    private GUID hostGUID;
    private Integer hostSpeedObj;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private String vendor;
    private boolean isChatSupported;
    private boolean isThexSupported;
    private boolean isBrowseHostSupported;
    private Short hostRating;
    private HostAddress hostAddress;
    private HostAddress[] pushProxyAddresses;

    public QueryHitHost(GUID gUID, HostAddress hostAddress, int n) {
        this.hostGUID = gUID;
        this.hostAddress = hostAddress;
        this.hostSpeedObj = new Integer(n);
        this.setQHDFlags((short)-1, (short)-1, (short)-1, (short)-1);
        this.hostRating = new Short(-1);
    }

    public void setQueryResponseFields(MsgQueryResponse msgQueryResponse) {
        this.setVendorCode(msgQueryResponse.getVendorCode());
        this.setChatSupported(msgQueryResponse.isChatSupported());
        this.setBrowseHostSupported(msgQueryResponse.isBrowseHostSupported());
        this.setPushProxyAddresses(msgQueryResponse.getPushProxyAddresses());
    }

    public HostAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(HostAddress[] hostAddressArray) {
        this.pushProxyAddresses = hostAddressArray;
    }

    public void setVendorCode(String string) {
        if (string != null) {
            this.vendor = VendorCodes.getVendorName(string);
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setChatSupported(boolean bl) {
        this.isChatSupported = bl;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setThexSupported(boolean bl) {
        this.isThexSupported = bl;
    }

    public boolean isThexSupported() {
        return this.isThexSupported;
    }

    public void setBrowseHostSupported(boolean bl) {
        this.isBrowseHostSupported = bl;
    }

    public boolean isBrowseHostSupported() {
        return this.isBrowseHostSupported;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void setHostGUID(GUID gUID) {
        this.hostGUID = gUID;
    }

    public int getHostSpeed() {
        return this.hostSpeedObj;
    }

    public void setHostSpeed(int n) {
        this.hostSpeedObj = new Integer(n);
        this.calculateHostRating();
    }

    public Integer getHostSpeedObject() {
        return this.hostSpeedObj;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setQHDFlags(short s, short s2, short s3, short s4) {
        this.pushNeededFlag = s;
        this.serverBusyFlag = s2;
        this.hasUploadedFlag = s3;
        this.uploadSpeedFlag = s4;
    }

    public boolean isPushNeeded() {
        return this.pushNeededFlag == 1;
    }

    public short getHostRating() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    public Short getHostRatingObject() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    private void calculateHostRating() {
        NetworkManager networkManager = NetworkManager.getInstance();
        if (this.pushNeededFlag == 1 && !networkManager.hasConnectedIncoming()) {
            this.hostRating = new Short(0);
            return;
        }
        if (this.serverBusyFlag == 1) {
            this.hostRating = new Short(1);
            return;
        }
        short s = this.pushNeededFlag == 1 ? (this.serverBusyFlag == 0 ? (short)3 : 2) : (this.pushNeededFlag == 0 ? (this.serverBusyFlag == 0 ? (short)6 : 5) : (!networkManager.hasConnectedIncoming() ? (short)3 : 4));
        if (this.hasUploadedFlag == 1) {
            s = (short)(s + 2);
        } else if (this.hasUploadedFlag == -1) {
            s = (short)(s + 1);
        }
        this.hostRating = new Short(s);
    }
}

