/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.Manager;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.msg.MsgQuery;
import phex.query.BackgroundSearchContainer;
import phex.query.DynamicQueryEngine;
import phex.query.DynamicQueryWorker;
import phex.query.QueryHistoryMonitor;
import phex.query.SearchContainer;
import phex.utils.Logger;

public class QueryManager
implements Manager {
    private QueryHistoryMonitor queryMonitor;
    private SearchContainer searchContainer;
    private BackgroundSearchContainer backgroundSearchContainer;
    private DynamicQueryWorker dynamicQueryWorker;
    private static QueryManager instance;

    public static QueryManager getInstance() {
        if (instance == null) {
            instance = new QueryManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.queryMonitor = new QueryHistoryMonitor();
        this.searchContainer = new SearchContainer();
        this.backgroundSearchContainer = new BackgroundSearchContainer();
        this.dynamicQueryWorker = new DynamicQueryWorker();
        return true;
    }

    public boolean onPostInitialization() {
        this.dynamicQueryWorker.startQueryWorker();
        return true;
    }

    public void startupCompletedNotify() {
        Environment.getInstance().scheduleTimerTask(new ExpiredSearchCheckTimer(), 5000L, 5000L);
    }

    public void shutdown() {
        this.queryMonitor.shutdown();
    }

    public QueryHistoryMonitor getQueryHistoryMonitor() {
        return this.queryMonitor;
    }

    public SearchContainer getSearchContainer() {
        return this.searchContainer;
    }

    public BackgroundSearchContainer getBackgroundSearchContainer() {
        return this.backgroundSearchContainer;
    }

    public void removeHostQueries(Host host) {
        if (host.isUltrapeerLeafConnection()) {
            this.dynamicQueryWorker.removeDynamicQuerysForHost(host);
        }
    }

    public DynamicQueryEngine sendDynamicQuery(MsgQuery msgQuery, int n) {
        DynamicQueryEngine dynamicQueryEngine = new DynamicQueryEngine(msgQuery, n);
        this.dynamicQueryWorker.addDynamicQueryEngine(dynamicQueryEngine);
        return dynamicQueryEngine;
    }

    public DynamicQueryEngine sendMyQuery(MsgQuery msgQuery) {
        MsgManager msgManager = MsgManager.getInstance();
        msgManager.checkAndAddToQueryRoutingTable(msgQuery.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (HostManager.getInstance().isUltrapeer()) {
            return this.sendDynamicQuery(msgQuery, 200);
        }
        msgManager.forwardQueryToUltrapeers(msgQuery, null);
        return null;
    }

    private class ExpiredSearchCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 5000L;

        private ExpiredSearchCheckTimer() {
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                QueryManager.this.searchContainer.stopExpiredSearches(l);
                QueryManager.this.backgroundSearchContainer.stopExpiredSearches(l);
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }
}

