/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.Cfg;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.query.BackgroundSearchContainer;
import phex.query.QueryManager;
import phex.query.Search;

public class ResearchSetting {
    private long lastResearchStartTime;
    private int noNewResultsCount;
    private int totalResearchCount;
    private String searchTerm;
    private Search search;
    private boolean hasNewSearchResults;
    private SWDownloadFile downloadFile;
    private ResearchChangeListener researchChangeListener;

    public ResearchSetting(SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.researchChangeListener = new ResearchChangeListener();
    }

    public long getLastResearchStartTime() {
        return this.lastResearchStartTime;
    }

    public void setLastResearchStartTime(long l) {
        this.lastResearchStartTime = l;
    }

    public int getNoNewResultsCount() {
        return this.noNewResultsCount;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String string) {
        this.searchTerm = string;
    }

    public String getSHA1() {
        URN uRN = this.downloadFile.getFileURN();
        if (uRN == null || !uRN.isSha1Nid()) {
            return "";
        }
        return uRN.getNamespaceSpecificString();
    }

    public void startSearch(long l) {
        long l2;
        if (this.search != null && this.search.isSearching()) {
            return;
        }
        if (this.searchTerm.length() < Cfg.MIN_SEARCH_TERM_LENGTH) {
            return;
        }
        this.hasNewSearchResults = false;
        BackgroundSearchContainer backgroundSearchContainer = QueryManager.getInstance().getBackgroundSearchContainer();
        this.search = backgroundSearchContainer.createSearch(this.searchTerm, this.downloadFile.getFileURN(), this.downloadFile.getTotalDataSize(), this.downloadFile.getTotalDataSize(), l);
        this.search.addSearchChangeListener(this.researchChangeListener);
        ++this.totalResearchCount;
        this.lastResearchStartTime = l2 = System.currentTimeMillis();
    }

    public int getTotalResearchCount() {
        return this.totalResearchCount;
    }

    public void stopSearch() {
        if (this.search == null || !this.search.isSearching()) {
            return;
        }
        this.search.stopSearching();
    }

    public int getSearchHitCount() {
        return this.search.getQueryHitCount();
    }

    public int getSearchProgress() {
        return this.search.getProgress();
    }

    public boolean isSearchRunning() {
        if (this.search == null) {
            return false;
        }
        return this.search.isSearching();
    }

    public class ResearchChangeListener
    implements SearchChangeListener {
        public void searchChanged(final SearchChangeEvent searchChangeEvent) {
            AsynchronousDispatcher.invokeLater(new Runnable(){

                public void run() {
                    if (searchChangeEvent.getType() == 4) {
                        if (!ResearchSetting.this.hasNewSearchResults) {
                            ResearchSetting.this.noNewResultsCount++;
                        } else {
                            ResearchSetting.this.noNewResultsCount = 0;
                        }
                    }
                    if (searchChangeEvent.getType() != 1) {
                        SwarmingManager.getInstance().fireDownloadFileChanged(ResearchSetting.this.downloadFile);
                        return;
                    }
                    Search search = (Search)searchChangeEvent.getSource();
                    int n = searchChangeEvent.getStartIndex();
                    int n2 = searchChangeEvent.getEndIndex();
                    for (int i = n; i < n2; ++i) {
                        RemoteFile remoteFile = search.getQueryHit(i);
                        boolean bl = ResearchSetting.this.downloadFile.addDownloadCandidate(remoteFile);
                        if (!bl) continue;
                        ResearchSetting.this.hasNewSearchResults = true;
                    }
                    SwarmingManager.getInstance().fireDownloadFileChanged(ResearchSetting.this.downloadFile);
                }
            });
        }
    }
}

