/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import phex.common.IntObj;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.connection.NetworkManager;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.QueryResponseRecord;
import phex.query.DynamicQueryEngine;
import phex.query.QueryHitHost;
import phex.query.QueryManager;
import phex.query.SearchFilter;
import phex.utils.Logger;
import phex.utils.SearchEngine;

public class Search {
    public static final long DEFAULT_SEARCH_TIMEOUT = 300000L;
    private long startTime;
    private String searchString;
    private URN searchURN;
    protected SearchFilter searchFilter;
    private DynamicQueryEngine queryEngine;
    private MsgQuery queryMsg;
    protected ArrayList queryHitList;
    protected ArrayList filteredQueryHitList;
    private IntObj queryHitCountObj;
    private IntObj locallyFilteredCountObj;
    private IntObj progressObj;
    private boolean isPermanentlyFiltered;
    protected boolean isSearching = false;
    private ArrayList listenerList = new ArrayList(2);

    public Search(String string) {
        this(string, null);
    }

    public Search(String string, URN uRN) {
        this.queryHitList = new ArrayList();
        this.filteredQueryHitList = new ArrayList();
        this.queryHitCountObj = new IntObj();
        this.locallyFilteredCountObj = new IntObj();
        this.progressObj = new IntObj();
        this.searchString = string;
        this.searchURN = uRN;
        boolean bl = !NetworkManager.getInstance().hasConnectedIncoming();
        this.queryMsg = new MsgQuery((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, false, bl);
        this.searchFilter = null;
    }

    public void setSearchString(String string) {
        this.searchString = string;
        this.searchURN = null;
        boolean bl = !NetworkManager.getInstance().hasConnectedIncoming();
        this.queryMsg = new MsgQuery((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, false, bl);
        this.fireSearchChanged();
        this.updateFilteredQueryList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchFilter(SearchFilter searchFilter) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.searchFilter = searchFilter;
            this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
            this.updateFilteredQueryList();
        }
    }

    public void setPermanentlyFilter(boolean bl) {
        this.isPermanentlyFiltered = bl;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public int getProgress() {
        if (!this.isSearching) {
            return 100;
        }
        if (this.queryEngine != null) {
            return this.queryEngine.getProgress();
        }
        long l = System.currentTimeMillis();
        int n = (int)(100.0 - (double)(this.startTime + 300000L - l) / 300000.0 * 100.0);
        return Math.min(n, 100);
    }

    public IntObj getProgressObj() {
        int n = this.getProgress();
        if (this.progressObj.value != n) {
            this.progressObj.value = n;
        }
        return this.progressObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryHitCount() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            return this.filteredQueryHitList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntObj getQueryHitCountObj() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            if (this.queryHitCountObj.intValue() != this.filteredQueryHitList.size()) {
                this.queryHitCountObj.setValue(this.filteredQueryHitList.size());
            }
            return this.queryHitCountObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile getQueryHit(int n) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.filteredQueryHitList.size()) {
                return null;
            }
            return (RemoteFile)this.filteredQueryHitList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] getQueryHits(int[] nArray) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            RemoteFile[] remoteFileArray = new RemoteFile[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                remoteFileArray[i] = (RemoteFile)this.filteredQueryHitList.get(nArray[i]);
            }
            return remoteFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocallyFilteredCount() {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.filteredQueryHitList;
            synchronized (arrayList2) {
                return this.queryHitList.size() - this.filteredQueryHitList.size();
            }
        }
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public void checkForSearchTimeout(long l) {
        if (this.queryEngine != null) {
            if (this.queryEngine.isQueryFinished()) {
                this.stopSearching();
            }
        } else if (l > this.startTime + 300000L) {
            this.stopSearching();
        }
    }

    public void startSearching() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Search.this.startTime = System.currentTimeMillis();
                Search.this.queryMsg.setCreationTime(Search.this.startTime);
                Logger.logMessage(Logger.FINER, (short)8, "Sending Query " + Search.this.queryMsg);
                Search.this.queryEngine = QueryManager.getInstance().sendMyQuery(Search.this.queryMsg);
                Search.this.isSearching = true;
                Search.this.fireSearchStarted();
            }
        });
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        if (this.queryEngine != null) {
            this.queryEngine.stopQuery();
        }
        this.fireSearchStoped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void processResponse(MsgQueryResponse msgQueryResponse) {
        if (!msgQueryResponse.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        int n = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n);
        queryHitHost.setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
        queryHitHost.setQueryResponseFields(msgQueryResponse);
        short s = queryHitHost.getHostRating();
        int n2 = this.queryHitList.size();
        int n3 = msgQueryResponse.getRecordCount();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(n3);
        int n4 = 0;
        while (true) {
            block14: {
                block16: {
                    RemoteFile remoteFile;
                    HostAddress[] hostAddressArray;
                    RemoteFile remoteFile2;
                    short s2;
                    String string;
                    int n5;
                    URN uRN;
                    String string2;
                    long l;
                    boolean bl;
                    block17: {
                        Object[] objectArray;
                        block13: {
                            QueryResponseRecord queryResponseRecord;
                            block15: {
                                if (n4 >= n3) break block13;
                                queryResponseRecord = msgQueryResponse.getMsgRecord(n4);
                                if (this.searchURN != null && queryResponseRecord.getURN() != null && !this.searchURN.equals(queryResponseRecord.getURN())) break block14;
                                objectArray = this.filteredQueryHitList;
                                // MONITORENTER : this.filteredQueryHitList
                                bl = false;
                                l = queryResponseRecord.getFileSize();
                                string2 = queryResponseRecord.getFilename();
                                if (this.searchFilter != null) {
                                    bl = this.searchFilter.isFiltered(l, string2, n, s);
                                }
                                if (!bl || !this.isPermanentlyFiltered) break block15;
                                // MONITOREXIT : objectArray
                                break block14;
                            }
                            uRN = queryResponseRecord.getURN();
                            n5 = queryResponseRecord.getFileIndex();
                            string = queryResponseRecord.getMetaData();
                            s2 = Search.calculateSearchScore(this.searchString, string2);
                            remoteFile2 = this.findQueryHit(queryHitHost, uRN, string2, l, n5);
                            if (remoteFile2 != null) {
                                remoteFile2.updateQueryHitHost(queryHitHost);
                                remoteFile2.setMetaData(string);
                            } else {
                                hostAddressArray = queryResponseRecord.getPathInfo();
                                remoteFile = new RemoteFile(queryHitHost, n5, string2, (String)hostAddressArray, l, uRN, string, s2);
                                this.queryHitList.add(remoteFile);
                                if (!bl) {
                                    this.filteredQueryHitList.add(remoteFile);
                                }
                                arrayList.add(remoteFile);
                            }
                            hostAddressArray = queryResponseRecord.getAlternateLocations();
                            if (uRN == null || hostAddressArray == null) break block16;
                            break block17;
                        }
                        n4 = this.queryHitList.size();
                        if (n4 <= n2) {
                            if (arrayList.size() <= 0) return;
                        }
                        if (this.queryEngine != null) {
                            this.queryEngine.incrementResultCount(arrayList.size());
                        }
                        objectArray = arrayList.toArray();
                        this.fireSearchHitsAdded(n2, n4, objectArray);
                        return;
                    }
                    for (int i = 0; i < hostAddressArray.length; ++i) {
                        QueryHitHost queryHitHost2 = new QueryHitHost(null, hostAddressArray[i], -1);
                        remoteFile2 = this.findQueryHit(queryHitHost, uRN, string2, l, n5);
                        if (remoteFile2 != null) {
                            remoteFile2.updateQueryHitHost(queryHitHost);
                            remoteFile2.setMetaData(string);
                            continue;
                        }
                        remoteFile = new RemoteFile(queryHitHost2, -1, string2, "", l, uRN, string, s2);
                        this.queryHitList.add(remoteFile);
                        if (!bl) {
                            this.filteredQueryHitList.add(remoteFile);
                        }
                        arrayList.add(remoteFile);
                    }
                }
                // MONITOREXIT : objectArray
            }
            ++n4;
        }
    }

    public static short calculateSearchScore(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            d += 1.0;
            searchEngine.setPattern(string3, false);
            if (!searchEngine.match()) continue;
            d2 += 1.0;
        }
        double d3 = d2 / d * 100.0;
        return (short)d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFile findQueryHit(QueryHitHost queryHitHost, URN uRN, String string, long l, int n) {
        GUID gUID = queryHitHost.getHostGUID();
        HostAddress hostAddress = queryHitHost.getHostAddress();
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            int n2 = this.queryHitList.size();
            for (int i = 0; i < n2; ++i) {
                HostAddress hostAddress2;
                RemoteFile remoteFile = (RemoteFile)this.queryHitList.get(i);
                GUID gUID2 = remoteFile.getQueryHitHost().getHostGUID();
                if (gUID2 == null || gUID == null ? !(hostAddress2 = remoteFile.getQueryHitHost().getHostAddress()).equals(hostAddress) : !gUID2.equals(gUID)) continue;
                if (uRN != null && remoteFile.getURN() != null) {
                    if (!uRN.equals(remoteFile.getURN())) continue;
                    return remoteFile;
                }
                if (n != remoteFile.getFileIndex() || l != remoteFile.getFileSize() || !string.equals(remoteFile.getFilename())) continue;
                return remoteFile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.filteredQueryHitList.clear();
            Iterator iterator = this.queryHitList.iterator();
            while (iterator.hasNext()) {
                RemoteFile remoteFile = (RemoteFile)iterator.next();
                boolean bl = false;
                if (this.searchFilter != null) {
                    bl = this.searchFilter.isFiltered(remoteFile.getFileSize(), remoteFile.getFilename(), remoteFile.getSpeed(), remoteFile.getQueryHitHost().getHostRating());
                }
                if (bl) continue;
                this.filteredQueryHitList.add(remoteFile);
            }
            this.fireSearchFiltered();
        }
    }

    public String toString() {
        return "[Search:" + this.searchString + "," + super.toString() + "]";
    }

    public void addSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.listenerList.add(searchChangeListener);
    }

    public void removeSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.listenerList.remove(searchChangeListener);
    }

    public void addSearchDataListener(SearchDataListener searchDataListener) {
        this.listenerList.add(searchDataListener);
    }

    public void removeSearchDataListener(SearchDataListener searchDataListener) {
        this.listenerList.remove(searchDataListener);
    }

    protected void fireSearchStarted() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 4);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchFiltered() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    public void fireSearchChanged() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(int n, int n2, Object[] objectArray) {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 1, n, n2);
        this.fireSearchChangeEvent(searchChangeEvent);
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 1, objectArray);
        this.fireSearchDataEvent(searchDataEvent);
    }

    private void fireSearchChangeEvent(final SearchChangeEvent searchChangeEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = Search.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!(objectArray[i] instanceof SearchChangeListener)) continue;
                    SearchChangeListener searchChangeListener = (SearchChangeListener)objectArray[i];
                    searchChangeListener.searchChanged(searchChangeEvent);
                }
            }
        });
    }

    private void fireSearchDataEvent(final SearchDataEvent searchDataEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = Search.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!(objectArray[i] instanceof SearchDataListener)) continue;
                    SearchDataListener searchDataListener = (SearchDataListener)objectArray[i];
                    searchDataListener.searchDataChanged(searchDataEvent);
                }
            }
        });
    }
}

