/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchFilterListListener;
import phex.query.SearchFilter;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBPhex;
import phex.xml.XJBSearchFilter;
import phex.xml.XJBSearchFilters;
import phex.xml.XMLBuilder;

public class SearchFilterContainer {
    private ArrayList searchFilterList;
    private ArrayList listenerList = new ArrayList(2);

    public SearchFilterContainer() {
        this.searchFilterList = new ArrayList();
        this.loadSearchFilters();
    }

    public int getSearchFilterCount() {
        return this.searchFilterList.size();
    }

    public SearchFilter getSearchFilterAt(int n) {
        if (n < 0 || n >= this.searchFilterList.size()) {
            return null;
        }
        return (SearchFilter)this.searchFilterList.get(n);
    }

    public SearchFilter getSearchFilterWithName(String string) {
        string = string.trim();
        for (int i = this.searchFilterList.size() - 1; i >= 0; --i) {
            SearchFilter searchFilter = (SearchFilter)this.searchFilterList.get(i);
            if (!searchFilter.getName().equals(string)) continue;
            return searchFilter;
        }
        return null;
    }

    public void addSearchFilter(SearchFilter searchFilter) {
        this.searchFilterList.add(0, searchFilter);
        this.fireSearchFilterAdded(0);
    }

    public void removeSearchFilter(SearchFilter searchFilter) {
        int n = this.searchFilterList.indexOf(searchFilter);
        if (n > -1) {
            this.searchFilterList.remove(n);
            this.saveSearchFilters();
            this.fireSearchFilterRemoved(n);
        }
    }

    public void saveSearchFilters() {
        Object object;
        Logger.logMessage(Logger.CONFIG, (short)8, "Saving search filters...");
        if (this.searchFilterList.size() == 0) {
            object = Environment.getInstance().getPhexConfigFile("filterlist.xml");
            ((File)object).delete();
        }
        try {
            object = new ObjectFactory();
            PhexElement phexElement = ((ObjectFactory)object).createPhexElement();
            phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
            XJBSearchFilters xJBSearchFilters = ((ObjectFactory)object).createXJBSearchFilters();
            phexElement.setSearchFilters(xJBSearchFilters);
            List list = xJBSearchFilters.getSearchFilterList();
            for (int i = this.searchFilterList.size() - 1; i >= 0; --i) {
                SearchFilter searchFilter = (SearchFilter)this.searchFilterList.get(i);
                XJBSearchFilter xJBSearchFilter = searchFilter.createXJBSearchFilter();
                list.add(xJBSearchFilter);
            }
            File file = Environment.getInstance().getPhexConfigFile("filterlist.xml");
            XMLBuilder.saveToFile(file, phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
    }

    public void loadSearchFilters() {
        XJBPhex xJBPhex;
        Logger.logMessage(Logger.CONFIG, (short)8, "Loading search filters...");
        File file = Environment.getInstance().getPhexConfigFile("filterlist.xml");
        try {
            xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                return;
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return;
        }
        List list = xJBPhex.getSearchFilters().getSearchFilterList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                XJBSearchFilter xJBSearchFilter = (XJBSearchFilter)iterator.next();
                SearchFilter searchFilter = SearchFilter.createFromxJBSearchFilter(xJBSearchFilter);
                this.searchFilterList.add(searchFilter);
            }
            catch (Exception exception) {
                Logger.logError(exception, "Error loading a search filter from XML.");
            }
        }
    }

    public void addSearchFilterListListener(SearchFilterListListener searchFilterListListener) {
        this.listenerList.add(searchFilterListListener);
    }

    public void removeSearchListChangeListener(SearchFilterListListener searchFilterListListener) {
        this.listenerList.remove(searchFilterListListener);
    }

    protected void fireSearchFilterChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchFilterContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchFilterListListener searchFilterListListener = (SearchFilterListListener)objectArray[i];
                    searchFilterListListener.searchFilterChanged(n);
                }
            }
        });
    }

    protected void fireSearchFilterAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchFilterContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchFilterListListener searchFilterListListener = (SearchFilterListListener)objectArray[i];
                    searchFilterListListener.searchFilterAdded(n);
                }
            }
        });
    }

    protected void fireSearchFilterRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchFilterContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchFilterListListener searchFilterListListener = (SearchFilterListListener)objectArray[i];
                    searchFilterListListener.searchFilterRemoved(n);
                }
            }
        });
    }

    protected void fireSearchFilterChanged(SearchFilter searchFilter) {
        int n = this.searchFilterList.indexOf(searchFilter);
        if (n >= 0) {
            this.fireSearchFilterChanged(n);
        }
    }
}

