/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.ExpiryDate;
import phex.common.Manager;
import phex.event.AsynchronousDispatcher;
import phex.event.SecurityRulesChangeListener;
import phex.host.HostAddress;
import phex.security.IPAccessRule;
import phex.security.SecurityRule;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBPhex;
import phex.xml.XJBSecurity;
import phex.xml.XJBSecurityRule;
import phex.xml.XMLBuilder;

public class PhexSecurityManager
implements Manager {
    public static final byte ACCESS_GRANTED = 1;
    public static final byte ACCESS_DENIED = 2;
    public static final byte ACCESS_STRONGLY_DENIED = 3;
    private static PhexSecurityManager instance;
    private ArrayList ipAccessRuleList;
    private ArrayList listenerList = new ArrayList(2);

    public PhexSecurityManager() {
        this.ipAccessRuleList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIPAccessRuleCount() {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            return this.ipAccessRuleList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule getIPAccessRule(int n) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.ipAccessRuleList.size()) {
                return null;
            }
            return (IPAccessRule)this.ipAccessRuleList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule[] getIPAccessRulesAt(int[] nArray) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = nArray.length;
            IPAccessRule[] iPAccessRuleArray = new IPAccessRule[n];
            int n2 = this.ipAccessRuleList.size();
            for (int i = 0; i < n; ++i) {
                iPAccessRuleArray[i] = nArray[i] < 0 || nArray[i] >= n2 ? null : (IPAccessRule)this.ipAccessRuleList.get(nArray[i]);
            }
            return iPAccessRuleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule createIPAccessRule(String string, boolean bl, byte by, byte[] byArray, byte[] byArray2, boolean bl2, ExpiryDate expiryDate, boolean bl3) {
        IPAccessRule iPAccessRule = new IPAccessRule(string, bl, by, byArray, byArray2);
        iPAccessRule.setDisabled(bl2);
        iPAccessRule.setExpiryDate(expiryDate);
        iPAccessRule.setDeleteOnExpiry(bl3);
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.size();
            this.ipAccessRuleList.add(n, iPAccessRule);
            this.fireSecurityRuleAdded(n);
        }
        return iPAccessRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRule(SecurityRule securityRule) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.indexOf(securityRule);
            if (n != -1) {
                this.ipAccessRuleList.remove(n);
                this.fireSecurityRuleRemoved(n);
            }
        }
    }

    public byte controlHostAddressAccess(HostAddress hostAddress) throws UnknownHostException {
        byte[] byArray = hostAddress.getHostIP();
        return this.controlHostIPAccess(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte controlHostIPAccess(byte[] byArray) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            Iterator iterator = this.ipAccessRuleList.iterator();
            while (iterator.hasNext()) {
                IPAccessRule iPAccessRule = (IPAccessRule)iterator.next();
                if (iPAccessRule.isDisabled() || iPAccessRule.isHostIPAllowed(byArray)) continue;
                if (iPAccessRule.isStrongFilter()) {
                    return 3;
                }
                return 2;
            }
        }
        return 1;
    }

    private void loadHostileHostList(XJBSecurity xJBSecurity) {
        try {
            String string;
            BufferedReader bufferedReader;
            Logger.logMessage(Logger.FINE, (short)16, "Load hostile hosts file.");
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/hostilehosts.cfg");
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            } else {
                Logger.logMessage(Logger.FINE, (short)16, "Hostile hosts file not found.");
                return;
            }
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                int n;
                byte[] byArray;
                byte[] byArray2;
                if (string.startsWith("#")) continue;
                int n2 = string.indexOf(47);
                if (n2 == -1) {
                    byArray2 = HostAddress.parseIP(string);
                    byArray = null;
                    n = 1;
                } else {
                    object = string.substring(0, n2).trim();
                    String string2 = string.substring(n2 + 1).trim();
                    byArray2 = HostAddress.parseIP((String)object);
                    byArray = HostAddress.parseIP(string2);
                    n = 2;
                }
                IPAccessRule iPAccessRule = new IPAccessRule("System rule.", true, (byte)n, byArray2, byArray);
                iPAccessRule.setSystemRule(true);
                iPAccessRule.setStrongFilter(true);
                iPAccessRule.setDisabled(false);
                object = this.findSystemXJBRule(xJBSecurity, byArray2, byArray);
                if (object != null) {
                    iPAccessRule.setTriggerCount(object.getTriggerCount());
                }
                this.ipAccessRuleList.add(iPAccessRule);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
        }
    }

    private XJBSecurityRule findSystemXJBRule(XJBSecurity xJBSecurity, byte[] byArray, byte[] byArray2) {
        List list = xJBSecurity.getIpAccessRuleList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XJBIPAccessRule xJBIPAccessRule = (XJBIPAccessRule)iterator.next();
            if (!xJBIPAccessRule.isSystemRule() || !Arrays.equals(xJBIPAccessRule.getIp(), byArray) || byArray2 == null || !Arrays.equals(xJBIPAccessRule.getCompareIP(), byArray2)) continue;
            return xJBIPAccessRule;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSecurityRuleList() {
        Logger.logMessage(Logger.CONFIG, (short)255, "Loading security rule list...");
        File file = Environment.getInstance().getPhexConfigFile("security.xml");
        ObjectFactory objectFactory = new ObjectFactory();
        try {
            XJBSecurity xJBSecurity;
            XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.SEVERE, (short)255, "Error loading security rule list.");
                xJBPhex = objectFactory.createXJBPhex();
            }
            if ((xJBSecurity = xJBPhex.getSecurity()) == null) {
                Logger.logMessage(Logger.FINE, (short)255, "No security definition found.");
                xJBSecurity = objectFactory.createXJBSecurity();
            }
            List list = xJBSecurity.getIpAccessRuleList();
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    XJBIPAccessRule xJBIPAccessRule = (XJBIPAccessRule)iterator.next();
                    if (xJBIPAccessRule.isSystemRule()) continue;
                    IPAccessRule iPAccessRule = new IPAccessRule(xJBIPAccessRule);
                    this.ipAccessRuleList.add(iPAccessRule);
                }
                this.loadHostileHostList(xJBSecurity);
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecurityRuleList() {
        Logger.logMessage(Logger.CONFIG, (short)255, "Saving security rule list...");
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            PhexElement phexElement = objectFactory.createPhexElement();
            XJBSecurity xJBSecurity = objectFactory.createXJBSecurity();
            phexElement.setSecurity(xJBSecurity);
            phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
            List list = xJBSecurity.getIpAccessRuleList();
            Serializable serializable = this.ipAccessRuleList;
            synchronized (serializable) {
                Iterator iterator = this.ipAccessRuleList.iterator();
                while (iterator.hasNext()) {
                    IPAccessRule iPAccessRule = (IPAccessRule)iterator.next();
                    if (!iPAccessRule.isSystemRule() && iPAccessRule.isDeletedOnExpiry() && (iPAccessRule.getExpiryDate().isExpiringEndOfSession() || iPAccessRule.getExpiryDate().isExpired())) continue;
                    XJBSecurityRule xJBSecurityRule = iPAccessRule.createXJBSecurityRule();
                    list.add(xJBSecurityRule);
                }
            }
            serializable = Environment.getInstance().getPhexConfigFile("security.xml");
            XMLBuilder.saveToFile((File)serializable, phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOldIpFilterIterator(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            int n;
            boolean bl = false;
            String[] stringArray = (String[])iterator.next();
            byte[] byArray = new byte[4];
            byte[] byArray2 = null;
            for (n = 0; n < 4; ++n) {
                if (stringArray[n].equals("*")) {
                    if (!bl) {
                        byArray2 = new byte[4];
                        for (int i = 0; i < n; ++i) {
                            byArray2[i] = byArray[i];
                        }
                        bl = true;
                    }
                    byArray[n] = 0;
                    byArray2[n] = -1;
                    continue;
                }
                byArray[n] = (byte)Integer.parseInt(stringArray[n]);
                if (!bl) continue;
                byArray2[n] = byArray[n];
            }
            n = bl ? 3 : 1;
            String string2 = Localizer.getFormatedString("ConvertedRule", new String[]{string});
            IPAccessRule iPAccessRule = new IPAccessRule(string2, true, (byte)n, byArray, byArray2);
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                this.ipAccessRuleList.add(iPAccessRule);
            }
        }
    }

    public static PhexSecurityManager getInstance() {
        if (instance == null) {
            instance = new PhexSecurityManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.loadSecurityRuleList();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.saveSecurityRuleList();
    }

    public void addUploadFilesChangeListener(SecurityRulesChangeListener securityRulesChangeListener) {
        this.listenerList.add(securityRulesChangeListener);
    }

    public void removeUploadFilesChangeListener(SecurityRulesChangeListener securityRulesChangeListener) {
        this.listenerList.remove(securityRulesChangeListener);
    }

    private void fireSecurityRuleChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[i];
                    securityRulesChangeListener.securityRuleChanged(n);
                }
            }
        });
    }

    private void fireSecurityRuleAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[i];
                    securityRulesChangeListener.securityRuleAdded(n);
                }
            }
        });
    }

    private void fireSecurityRuleRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[i];
                    securityRulesChangeListener.securityRuleRemoved(n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSecurityRuleChanged(SecurityRule securityRule) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.indexOf(securityRule);
            if (n >= 0) {
                this.fireSecurityRuleChanged(n);
            }
        }
    }
}

