/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import phex.common.AlternateLocation;
import phex.common.AlternateLocationContainer;
import phex.common.URN;
import phex.host.HostAddress;
import phex.http.Range;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.share.SharedResource;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBAlternateLocation;
import phex.xml.XJBSharedFile;

public class ShareFile
extends SharedResource {
    private int fileIndex;
    private Long fileSize;
    private URN urn;
    private char[] searchCompareTerm;
    private Integer searchCount;
    private Integer uploadCount;
    private AlternateLocationContainer alternateLocations;

    public ShareFile(File file) {
        super(file);
        this.fileSize = new Long(this.systemFile.length());
        this.searchCount = new Integer(0);
        this.uploadCount = new Integer(0);
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        String string = sharedFilesService.getSharedFilePath(this.systemFile);
        this.searchCompareTerm = string.toLowerCase().toCharArray();
    }

    protected ShareFile(long l) {
        this.fileSize = new Long(l);
    }

    public URN getURN() {
        return this.urn;
    }

    public void setURN(URN uRN) {
        this.urn = uRN;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int n) {
        this.fileIndex = n;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public short getRangeAvailableStatus(Range range) {
        long l = this.fileSize;
        long l2 = range.getStartOffset(l);
        if (l2 < 0L || l2 >= l) {
            return 2;
        }
        return 0;
    }

    public AlternateLocationContainer getAltLocContainer() {
        if (this.alternateLocations == null) {
            this.alternateLocations = new AlternateLocationContainer(this.urn);
        }
        return this.alternateLocations;
    }

    public Integer getSearchCountObject() {
        return this.searchCount;
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        this.searchCount = new Integer(this.searchCount + 1);
    }

    public Integer getUploadCountObject() {
        return this.uploadCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        this.uploadCount = new Integer(this.uploadCount + 1);
    }

    public char[] getSearchCompareTerm() {
        return this.searchCompareTerm;
    }

    public void updateFromCache(XJBSharedFile xJBSharedFile) {
        this.searchCount = new Integer(xJBSharedFile.getHitCount());
        this.uploadCount = new Integer(xJBSharedFile.getUploadCount());
        this.urn = new URN("urn:sha1:" + xJBSharedFile.getSHA1());
        List list = xJBSharedFile.getAltLoc();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                XJBAlternateLocation xJBAlternateLocation = (XJBAlternateLocation)iterator.next();
                String string = xJBAlternateLocation.getHostAddress();
                String string2 = xJBAlternateLocation.getURN();
                if (string2 == null) continue;
                AlternateLocation alternateLocation = new AlternateLocation(new HostAddress(string), new URN(string2));
                this.getAltLocContainer().addAlternateLocation(alternateLocation);
            }
            catch (Exception exception) {
                Logger.logError(exception, "AlternateLocation skipped due to error.");
            }
        }
    }

    public XJBSharedFile createXJBSharedFile() throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        XJBSharedFile xJBSharedFile = objectFactory.createXJBSharedFile();
        xJBSharedFile.setFileName(this.systemFile.getAbsolutePath());
        xJBSharedFile.setSHA1(this.getSHA1());
        xJBSharedFile.setLastModified(this.systemFile.lastModified());
        xJBSharedFile.setHitCount(this.searchCount);
        xJBSharedFile.setUploadCount(this.uploadCount);
        if (this.alternateLocations != null) {
            this.alternateLocations.createXJBAlternateLocationList(xJBSharedFile.getAltLoc());
        }
        return xJBSharedFile;
    }

    public String toString() {
        return super.toString() + " " + this.getFileName() + "  " + this.fileIndex;
    }
}

