/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.RunnerQueueWorker;
import phex.common.URN;
import phex.event.AsynchronousDispatcher;
import phex.event.ShareChangeListener;
import phex.share.FileRescanRunner;
import phex.share.ShareFile;
import phex.share.SharedDirectory;
import phex.share.SharedResource;
import phex.share.UrnCalculationWorker;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.ReadWriteLock;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBPhex;
import phex.xml.XJBSharedFile;
import phex.xml.XJBSharedLibrary;
import phex.xml.XMLBuilder;

public class SharedFilesService {
    private ReadWriteLock rwLock;
    private HashMap directoryShareMap;
    private HashMap urnToFileMap;
    private HashMap nameToFileMap;
    private ArrayList indexedSharedFiles;
    private ArrayList sharedFiles;
    private int totalFileSizeKb;
    private RunnerQueueWorker urnCalculationRunner;
    private ArrayList listenerList = new ArrayList(2);
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedFilesService() {
        this.rwLock = new ReadWriteLock();
        this.urnCalculationRunner = new RunnerQueueWorker();
        Environment.getInstance().scheduleTimerTask(new FileRescanTimer(), 60000L, 60000L);
        this.directoryShareMap = new HashMap();
        this.urnToFileMap = new HashMap();
        this.nameToFileMap = new HashMap();
        this.indexedSharedFiles = new ArrayList();
        this.sharedFiles = new ArrayList();
        this.totalFileSizeKb = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSharedFilePath(File file) {
        this.rwLock.readLock();
        try {
            Object object;
            File file2;
            File file3 = file.getParentFile();
            Iterator iterator = this.directoryShareMap.keySet().iterator();
            while (iterator.hasNext()) {
                file2 = (File)iterator.next();
                object = (SharedDirectory)this.directoryShareMap.get(file2);
                if (((SharedDirectory)object).getType() != 1 || !FileUtils.isChildOfDir(file, file2) || !FileUtils.isChildOfDir(file3, file2)) continue;
                file3 = file2;
            }
            file2 = file3.getParentFile();
            if (file2 != null) {
                file3 = file2;
            }
            object = file3.getAbsolutePath();
            int n = ((String)object).length();
            if (!((String)object).endsWith(File.separator)) {
                ++n;
            }
            String string = file.getAbsolutePath().substring(n);
            return string;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByName(String string) {
        this.rwLock.readLock();
        try {
            ShareFile shareFile = (ShareFile)this.nameToFileMap.get(string);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    public ShareFile getShareFileByFile(File file) {
        return this.getFileByName(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileAt(int n) {
        this.rwLock.readLock();
        try {
            if (n >= this.sharedFiles.size()) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = (ShareFile)this.sharedFiles.get(n);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile[] getSharedFiles() {
        this.rwLock.readLock();
        try {
            ShareFile[] shareFileArray = new ShareFile[this.sharedFiles.size()];
            ShareFile[] shareFileArray2 = shareFileArray = this.sharedFiles.toArray(shareFileArray);
            return shareFileArray2;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        this.rwLock.readLock();
        try {
            int n = this.sharedFiles.size();
            return n;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalFileSizeInKb() {
        this.rwLock.readLock();
        try {
            int n = this.totalFileSizeKb;
            return n;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByIndex(int n) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (n >= this.indexedSharedFiles.size()) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = (ShareFile)this.indexedSharedFiles.get(n);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByURN(URN uRN) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (uRN == null) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = (ShareFile)this.urnToFileMap.get(uRN);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNShared(URN uRN) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (uRN == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.urnToFileMap.containsKey(uRN);
            return bl;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilesByURNs(URN[] uRNArray) {
        this.rwLock.readLock();
        try {
            ArrayList arrayList = new ArrayList(uRNArray.length);
            for (int i = 0; i < uRNArray.length; ++i) {
                Object v = this.urnToFileMap.get(uRNArray[i]);
                if (v == null) continue;
                arrayList.add(v);
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSharedFile(ShareFile shareFile) {
        File file = shareFile.getSystemFile();
        if (this.getFileByName(file.getAbsolutePath()) != null) {
            return;
        }
        this.rwLock.writeLock();
        try {
            int n = this.indexedSharedFiles.size();
            shareFile.setFileIndex(n);
            this.indexedSharedFiles.add(n, shareFile);
            n = this.sharedFiles.size();
            this.sharedFiles.add(n, shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / 1024L);
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            int n = shareFile.getFileIndex();
            this.indexedSharedFiles.set(n, null);
            File file = shareFile.getSystemFile();
            this.urnToFileMap.remove(shareFile.getURN());
            this.nameToFileMap.remove(file.getAbsolutePath());
            int n2 = this.sharedFiles.indexOf(shareFile);
            if (n2 != -1) {
                this.sharedFiles.remove(n2);
                this.totalFileSizeKb = (int)((long)this.totalFileSizeKb - shareFile.getFileSize() / 1024L);
            }
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSharedDirecotries(HashMap hashMap) {
        this.rwLock.writeLock();
        try {
            this.directoryShareMap.clear();
            this.directoryShareMap.putAll(hashMap);
            this.sharedDirectoriesChanged();
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory getSharedDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        this.rwLock.readLock();
        try {
            SharedResource sharedResource = (SharedResource)this.directoryShareMap.get(file);
            if (sharedResource instanceof SharedDirectory) {
                SharedDirectory sharedDirectory = (SharedDirectory)sharedResource;
                return sharedDirectory;
            }
            SharedDirectory sharedDirectory = null;
            return sharedDirectory;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    public void addUrn2FileMapping(ShareFile shareFile) {
        if (!$assertionsDisabled && shareFile.getURN() == null) {
            throw new AssertionError();
        }
        this.urnToFileMap.put(shareFile.getURN(), shareFile);
    }

    public void queueUrnCalculation(ShareFile shareFile) {
        UrnCalculationWorker urnCalculationWorker = new UrnCalculationWorker(shareFile);
        this.urnCalculationRunner.add(urnCalculationWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSharedFiles() {
        this.rwLock.writeLock();
        try {
            this.urnCalculationRunner.stopAndClear();
            this.sharedFiles.clear();
            this.indexedSharedFiles.clear();
            this.urnToFileMap.clear();
            this.nameToFileMap.clear();
            this.totalFileSizeKb = 0;
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    public XJBSharedLibrary loadSharedLibrary() {
        XJBPhex xJBPhex;
        Logger.logMessage(Logger.FINE, (short)4, "Load shared library configuration file.");
        File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
        ObjectFactory objectFactory = new ObjectFactory();
        try {
            xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.FINE, (short)4, "No shared library configuration file found.");
                return objectFactory.createXJBSharedLibrary();
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            try {
                return objectFactory.createXJBSharedLibrary();
            }
            catch (JAXBException jAXBException2) {
                Logger.logError(jAXBException2);
                throw new RuntimeException(jAXBException2.getMessage());
            }
        }
        XJBSharedLibrary xJBSharedLibrary = xJBPhex.getSharedLibrary();
        return xJBSharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSharedLibrary() {
        Logger.logMessage(Logger.FINEST, (short)4, "Saving shared library.");
        this.rwLock.readLock();
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            PhexElement phexElement = objectFactory.createPhexElement();
            XJBSharedLibrary xJBSharedLibrary = this.createXJBSharedLibrary();
            phexElement.setSharedLibrary(xJBSharedLibrary);
            phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
            File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
            XMLBuilder.saveToFile(file, phexElement);
        }
        catch (JAXBException jAXBException) {
            Throwable throwable = jAXBException.getLinkedException();
            if (throwable != null) {
                Logger.logError(throwable);
            }
            Logger.logError(jAXBException);
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XJBSharedLibrary createXJBSharedLibrary() throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        XJBSharedLibrary xJBSharedLibrary = objectFactory.createXJBSharedLibrary();
        this.rwLock.readLock();
        try {
            Iterator iterator = this.sharedFiles.iterator();
            List list = xJBSharedLibrary.getSharedFileList();
            while (iterator.hasNext()) {
                try {
                    ShareFile shareFile = (ShareFile)iterator.next();
                    if (shareFile.getURN() == null) continue;
                    XJBSharedFile xJBSharedFile = shareFile.createXJBSharedFile();
                    list.add(xJBSharedFile);
                }
                catch (Exception exception) {
                    Logger.logError(exception, "SharedFile skipped due to error.");
                }
            }
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
        }
        return xJBSharedLibrary;
    }

    public void addSharedFilesChangeListener(ShareChangeListener shareChangeListener) {
        this.listenerList.add(shareChangeListener);
    }

    public void removeSharedFilesChangeListener(ShareChangeListener shareChangeListener) {
        this.listenerList.remove(shareChangeListener);
    }

    private void sharedDirectoriesChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SharedFilesService.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ShareChangeListener shareChangeListener = (ShareChangeListener)objectArray[i];
                    shareChangeListener.sharedDirectoriesChanged();
                }
            }
        });
    }

    static {
        $assertionsDisabled = !SharedFilesService.class.desiredAssertionStatus();
    }

    private class FileRescanTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private FileRescanTimer() {
        }

        public void run() {
            try {
                FileRescanRunner.rescan(false, false);
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }
}

