/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import phex.common.ThreadPool;
import phex.share.export.SharedFilesPipeFiller;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class ExportEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExport(InputStream inputStream, OutputStream outputStream) {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream();
        try {
            pipedOutputStream.connect(pipedInputStream);
            SharedFilesPipeFiller sharedFilesPipeFiller = new SharedFilesPipeFiller(pipedOutputStream);
            ThreadPool.getInstance().addJob(sharedFilesPipeFiller, "SharedFilesPipeFiller");
            StreamSource streamSource = new StreamSource(inputStream);
            StreamSource streamSource2 = new StreamSource(pipedInputStream);
            StreamResult streamResult = new StreamResult(outputStream);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer(streamSource);
                transformer.transform(streamSource2, streamResult);
            }
            catch (TransformerException transformerException) {
                Logger.logError(transformerException);
            }
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        finally {
            IOUtil.closeQuietly(pipedInputStream);
            IOUtil.closeQuietly(pipedOutputStream);
        }
    }
}

