/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.URLUtil;
import phex.xml.XMLUtils;

public class SharedFilesPipeFiller
implements Runnable {
    private Writer utf8Writer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedFilesPipeFiller(OutputStream outputStream) {
        block2: {
            try {
                this.utf8Writer = new OutputStreamWriter(outputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.utf8Writer.write("<shared-file-list>");
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            ShareFile[] shareFileArray = sharedFilesService.getSharedFiles();
            for (int i = 0; i < shareFileArray.length; ++i) {
                ShareFile shareFile = shareFileArray[i];
                this.utf8Writer.write("<shared-file>");
                this.utf8Writer.write("<index>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getFileIndex()));
                this.utf8Writer.write("</index>");
                this.utf8Writer.write("<name>");
                XMLUtils.writeEncoded(this.utf8Writer, shareFile.getFileName());
                this.utf8Writer.write("</name>");
                this.utf8Writer.write("<search-compare-term>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getSearchCompareTerm()));
                this.utf8Writer.write("</search-compare-term>>");
                this.utf8Writer.write("<search-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getSearchCount()));
                this.utf8Writer.write("</search-count>");
                this.utf8Writer.write("<sha1>");
                XMLUtils.writeEncoded(this.utf8Writer, shareFile.getSHA1());
                this.utf8Writer.write("</sha1>");
                this.utf8Writer.write("<upload-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getUploadCount()));
                this.utf8Writer.write("</upload-count>");
                this.utf8Writer.write("<file-size>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getFileSize()));
                this.utf8Writer.write("</file-size>");
                this.utf8Writer.write("<urn>");
                XMLUtils.writeEncoded(this.utf8Writer, shareFile.getURN().getAsString());
                this.utf8Writer.write("</urn>");
                this.utf8Writer.write("<magnet-url>");
                XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURL(shareFile.getSHA1(), shareFile.getFileName()));
                this.utf8Writer.write("</magnet-url>");
                this.utf8Writer.write("</shared-file>");
            }
            this.utf8Writer.write("</shared-file-list>");
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        finally {
            IOUtil.closeQuietly(this.utf8Writer);
        }
    }

    static {
        $assertionsDisabled = !SharedFilesPipeFiller.class.desiredAssertionStatus();
    }
}

