/*
 * Decompiled with CFR 0.152.
 */
package phex.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.common.Environment;

public class GWebCacheListBuilder {
    private static final String listUrl = "http://www.rodage.net/gnetcache/gcache.php?urlfile=1000";
    private static List dataList;

    public static void main(String[] stringArray) throws Exception {
        dataList = new ArrayList();
        System.setProperty("http.agent", Environment.getPhexVendor());
        URL uRL = new URL(listUrl);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        GWebCacheListBuilder.readData(inputStream);
        System.out.println("Total data read: " + dataList.size());
        inputStream.close();
        GWebCacheListBuilder.writeToOutputFile();
    }

    private static void readData(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string != null && string.startsWith("ERROR")) {
            System.err.println(string);
            return;
        }
        while (string != null) {
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equals("http")) {
                    System.err.println("Skipped " + string);
                    continue;
                }
                dataList.add(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Skipped " + string);
            }
            string = bufferedReader.readLine();
        }
    }

    private static void writeToOutputFile() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("src/phex/resources/gwebcache.cfg"));
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            bufferedWriter.write(string + "\n");
        }
        bufferedWriter.close();
    }
}

