/*
 * Decompiled with CFR 0.152.
 */
package phex.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phex.utils.IOUtil;
import phex.utils.Localizer;

public class TranslationAssistant {
    public static void main(String[] stringArray) {
        TranslationAssistant translationAssistant = new TranslationAssistant();
        long l = System.currentTimeMillis();
        translationAssistant.findUnusedKeys();
        translationAssistant.findMissingKeys();
        long l2 = System.currentTimeMillis();
        System.out.println("---Time: " + (l2 - l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMissingKeys() {
        List list = this.getAllPossibleLangFiles();
        InputStream inputStream = Localizer.class.getResourceAsStream("/phex/resources/Lang.properties");
        inputStream = new BufferedInputStream(inputStream);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            IOUtil.closeQuietly(inputStream);
        }
        Set<Object> set = properties.keySet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            inputStream = (class$phex$utils$Localizer == null ? TranslationAssistant.class$("phex.utils.Localizer") : class$phex$utils$Localizer).getResourceAsStream(string = (String)iterator.next());
            if (inputStream == null) continue;
            inputStream = new BufferedInputStream(inputStream);
            Properties properties2 = new Properties();
            try {
                properties2.load(inputStream);
                Set<Object> set2 = properties2.keySet();
                HashSet<Object> hashSet = new HashSet<Object>(set);
                hashSet.removeAll(set2);
                Iterator iterator2 = hashSet.iterator();
                if (!iterator2.hasNext()) continue;
                System.out.println("---Missing Keys in " + string);
                while (iterator2.hasNext()) {
                    System.out.println(iterator2.next());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                IOUtil.closeQuietly(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findUnusedKeys() {
        List list = this.getAllPossibleLangFiles();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            InputStream inputStream = (class$phex$utils$Localizer == null ? TranslationAssistant.class$("phex.utils.Localizer") : class$phex$utils$Localizer).getResourceAsStream(string = (String)iterator.next());
            if (inputStream == null) continue;
            inputStream = new BufferedInputStream(inputStream);
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                Set<Object> set = properties.keySet();
                this.findUnusedKeys(set, new File("src/phex"));
                System.out.println("---Unused Keys in " + string);
                Iterator<Object> iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    System.out.println(iterator2.next());
                }
            }
            catch (IOException iOException) {}
            continue;
            finally {
                IOUtil.closeQuietly(inputStream);
            }
        }
    }

    private void findUnusedKeysRegEx(Set set, File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("java");
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                this.findUnusedKeysRegEx(set, fileArray[i]);
            }
        } else {
            System.out.println("searching " + set.size() + " : " + file);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            fileChannel.read(byteBuffer);
            byteBuffer.rewind();
            CharBuffer charBuffer = Charset.forName("US-ASCII").decode(byteBuffer);
            String[] stringArray = set.toArray(new String[set.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                Pattern pattern = Pattern.compile(".*" + stringArray[i] + ".*", 32);
                Matcher matcher = pattern.matcher(charBuffer);
                if (!matcher.matches()) continue;
                set.remove(stringArray[i]);
            }
        }
    }

    private void findUnusedKeys(Set set, File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("java");
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                this.findUnusedKeys(set, fileArray[i]);
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            fileChannel.read(byteBuffer);
            byteBuffer.rewind();
            String string = new String(byteBuffer.array(), "US-ASCII");
            String[] stringArray = set.toArray(new String[set.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) == -1) continue;
                set.remove(stringArray[i]);
            }
        }
    }

    private List getAllPossibleLangFiles() {
        List list = Localizer.getAvailableLocales();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/phex/resources/Lang.properties");
        arrayList.add("/Lang.properties");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Locale locale = (Locale)iterator.next();
            StringBuffer stringBuffer = new StringBuffer("Lang");
            String string = locale.getLanguage();
            if (string.length() <= 0) continue;
            stringBuffer.append('_');
            stringBuffer.append(string);
            arrayList.add("/phex/resources/" + stringBuffer.toString() + ".properties");
            arrayList.add("/" + stringBuffer.toString() + ".properties");
            String string2 = locale.getCountry();
            if (string2.length() <= 0) continue;
            stringBuffer.append('_');
            stringBuffer.append(string2);
            arrayList.add("/phex/resources/" + stringBuffer.toString() + ".properties");
            arrayList.add("/" + stringBuffer.toString() + ".properties");
        }
        return arrayList;
    }
}

