/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SystemUtils;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.event.UpdateNotificationListener;
import phex.gui.common.GUIRegistry;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBPhex;
import phex.xml.XJBUpdateRequest;
import phex.xml.XJBUpdateResponse;
import phex.xml.XMLBuilder;

public class UpdateCheckRunner
implements Runnable {
    private static final String UPDATE_CHECK_URL = "http://phex.kouk.de/update/update.php";
    private Throwable updateCheckError;
    private UpdateNotificationListener listener;
    private String releaseVersion;
    private String betaVersion;

    public UpdateCheckRunner(UpdateNotificationListener updateNotificationListener) {
        this.listener = updateNotificationListener;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public Throwable getUpdateCheckError() {
        return this.updateCheckError;
    }

    public void run() {
        try {
            this.performUpdateCheck();
        }
        catch (Throwable throwable) {
            this.updateCheckError = throwable;
        }
    }

    private void performUpdateCheck() {
        XJBPhex xJBPhex;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            URL uRL = new URL(UPDATE_CHECK_URL);
            object4 = (HttpURLConnection)uRL.openConnection();
            ((URLConnection)object4).setUseCaches(false);
            ((URLConnection)object4).setRequestProperty("User-Agent", Environment.getPhexVendor());
            ((HttpURLConnection)object4).setRequestMethod("POST");
            ((URLConnection)object4).setDoOutput(true);
            ((URLConnection)object4).setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            object3 = ((URLConnection)object4).getOutputStream();
            object2 = this.buildXMLUpdateRequest();
            if (object2 == null) {
                throw new IOException("Missing XML update data");
            }
            ((OutputStream)object3).write((byte[])object2);
            object = ((URLConnection)object4).getInputStream();
            xJBPhex = XMLBuilder.readXJBPhexFromStream((InputStream)object);
        }
        catch (MalformedURLException malformedURLException) {
            this.updateCheckError = malformedURLException;
            Logger.logError(malformedURLException);
            throw new RuntimeException();
        }
        catch (UnknownHostException unknownHostException) {
            this.updateCheckError = unknownHostException;
            return;
        }
        catch (SocketException socketException) {
            this.updateCheckError = socketException;
            return;
        }
        catch (IOException iOException) {
            this.updateCheckError = iOException;
            Logger.logWarning(iOException);
            return;
        }
        catch (JAXBException jAXBException) {
            this.updateCheckError = jAXBException;
            Logger.logWarning(jAXBException);
            return;
        }
        ServiceManager.sCfg.lastUpdateCheckTime = System.currentTimeMillis();
        if (!ServiceManager.sCfg.showUpdateNotification) {
            ServiceManager.sCfg.save();
            return;
        }
        object4 = xJBPhex.getUpdateResponse();
        object3 = object4.getVersionList();
        object2 = object3.iterator();
        object = null;
        XJBUpdateResponse.VersionType versionType = null;
        while (object2.hasNext()) {
            XJBUpdateResponse.VersionType versionType2 = (XJBUpdateResponse.VersionType)object2.next();
            if (versionType2.isBeta()) {
                if (versionType != null && VersionUtils.compare(versionType2.getId(), versionType.getId()) <= 0) continue;
                versionType = versionType2;
                continue;
            }
            if (object != null && VersionUtils.compare(versionType2.getId(), object.getId()) <= 0) continue;
            object = versionType2;
        }
        this.betaVersion = "0";
        this.releaseVersion = "0";
        if (versionType != null) {
            this.betaVersion = versionType.getId();
        }
        if (object != null) {
            this.releaseVersion = object.getId();
        }
        int n = 0;
        int n2 = 0;
        n2 = VersionUtils.compare(this.betaVersion, VersionUtils.getFullProgramVersion());
        n = VersionUtils.compare(this.releaseVersion, VersionUtils.getFullProgramVersion());
        if (n <= 0 && n2 <= 0) {
            ServiceManager.sCfg.save();
            return;
        }
        n2 = VersionUtils.compare(this.betaVersion, ServiceManager.sCfg.lastBetaUpdateCheckVersion);
        n = VersionUtils.compare(this.releaseVersion, ServiceManager.sCfg.lastUpdateCheckVersion);
        int n3 = VersionUtils.compare(this.betaVersion, this.releaseVersion);
        boolean bl = false;
        if (n > 0) {
            ServiceManager.sCfg.lastUpdateCheckVersion = this.releaseVersion;
            bl = true;
        }
        if (n2 > 0) {
            ServiceManager.sCfg.lastBetaUpdateCheckVersion = this.betaVersion;
            bl = true;
        }
        if (n3 > 0) {
            this.releaseVersion = null;
        } else {
            this.betaVersion = null;
        }
        ServiceManager.sCfg.save();
        if (bl) {
            this.fireUpdateNotification();
        }
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private byte[] buildXMLUpdateRequest() {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            PhexElement phexElement = objectFactory.createPhexElement();
            XJBUpdateRequest xJBUpdateRequest = objectFactory.createXJBUpdateRequest();
            phexElement.setUpdateRequest(xJBUpdateRequest);
            xJBUpdateRequest.setCurrentVersion(VersionUtils.getFullProgramVersion());
            xJBUpdateRequest.setLafUsed(GUIRegistry.getInstance().getUsedLAFClass());
            xJBUpdateRequest.setJavaVersion(System.getProperty("java.version"));
            xJBUpdateRequest.setOperatingSystem(SystemUtils.OS_NAME);
            Cfg cfg = ServiceManager.sCfg;
            xJBUpdateRequest.setHostid(cfg.mProgramClientID.toHexString());
            xJBUpdateRequest.setShowBetaInfo(cfg.showBetaUpdateNotification);
            xJBUpdateRequest.setLastInfoId(cfg.lastShownUpdateInfoId);
            String string = VersionUtils.compare(cfg.lastUpdateCheckVersion, cfg.lastBetaUpdateCheckVersion) > 0 ? cfg.lastUpdateCheckVersion : cfg.lastBetaUpdateCheckVersion;
            xJBUpdateRequest.setLastCheckVersion(string);
            StatisticsManager statisticsManager = StatisticsManager.getInstance();
            StatisticProvider statisticProvider = statisticsManager.getStatisticProvider("UptimeProvider");
            xJBUpdateRequest.setAvgUptime(((LongObj)statisticProvider.getAverageValue()).value);
            StatisticProvider statisticProvider2 = statisticsManager.getStatisticProvider("TotalDownloadCountProvider");
            xJBUpdateRequest.setDownloadCount((int)((LongObj)statisticProvider2.getValue()).value);
            StatisticProvider statisticProvider3 = statisticsManager.getStatisticProvider("TotalUploadCountProvider");
            xJBUpdateRequest.setUploadCount((int)((LongObj)statisticProvider3.getValue()).value);
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            xJBUpdateRequest.setSharedFiles(sharedFilesService.getFileCount());
            xJBUpdateRequest.setSharedSize(sharedFilesService.getTotalFileSizeInKb());
            return XMLBuilder.serializeToBytes(phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return null;
        }
    }
}

