/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import phex.common.AlternateLocationContainer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.Range;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.share.PartialShareFile;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class UploadEngine {
    private static final int BUFFER_LENGTH = 1024;
    private RandomAccessFile raFile;
    private final Connection connection;
    private Socket socket;
    private OutputStream outStream;
    private GnutellaInputStream inStream;
    private boolean isUploadQueued;
    private long minNextPollTime;
    private long startOffset;
    private long endOffset;
    private long fileStartOffset;
    private HTTPRequest httpRequest;
    private UploadState uploadState;
    private boolean isIPCounted;
    private HostAddress hostAddress;
    private Set sendAltLocSet;
    public boolean isUploadCounted;
    private boolean isPersistentConnection;
    private boolean isThexRequest;
    private ShareFile uploadShareFile;

    public UploadEngine(Connection connection, HTTPRequest hTTPRequest) throws IOException {
        this.connection = connection;
        this.socket = connection.getSocket();
        this.inStream = connection.getInputStream();
        connection.setBandwidthController(BandwidthManager.getInstance().getUploadBandwidthController());
        this.outStream = this.socket.getOutputStream();
        this.httpRequest = hTTPRequest;
        this.isIPCounted = false;
        this.isUploadCounted = false;
        this.sendAltLocSet = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpload() throws IOException {
        Logger.logMessage(Logger.FINE, (short)4, "Upload Engine starts upload.");
        try {
            do {
                boolean bl;
                if (!(bl = this.evaluateHTTPRequest())) {
                    return;
                }
                try {
                    if (!this.isUploadQueued) {
                        this.sendBinaryData();
                    }
                }
                catch (IOException iOException) {
                    this.uploadState.setStatus((short)4);
                    throw iOException;
                }
                if (!this.isPersistentConnection) continue;
                try {
                    this.readNextHTTPRequest();
                }
                catch (IOException iOException) {
                    Logger.logMessage(Logger.FINE, (short)4, iOException);
                    this.isPersistentConnection = false;
                }
            } while (this.isPersistentConnection);
        }
        catch (Exception exception) {
            this.uploadState.setStatus((short)4);
            Logger.logWarning(exception);
        }
        finally {
            this.stopUpload();
            UploadManager uploadManager = UploadManager.getInstance();
            if (this.isIPCounted) {
                uploadManager.releaseUploadIP(this.hostAddress);
            }
            if (this.uploadState != null) {
                this.uploadState.setUploadEngine(null);
            }
            if (this.isUploadQueued) {
                uploadManager.removeQueuedUpload(this.uploadState);
            }
        }
    }

    public void stopUpload() {
        IOUtil.closeQuietly(this.inStream);
        IOUtil.closeQuietly(this.outStream);
        IOUtil.closeQuietly(this.socket);
        if (this.raFile != null) {
            try {
                this.raFile.getFD().sync();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendBinaryData() throws IOException {
        StatisticProvider statisticProvider;
        Object object;
        Logger.logMessage(Logger.FINE, (short)4, "About to send binary range: " + this.startOffset + " to " + this.endOffset);
        if (!this.isUploadCounted) {
            this.uploadShareFile.incUploadCount();
            object = StatisticsManager.getInstance();
            statisticProvider = (SimpleStatisticProvider)((StatisticsManager)object).getStatisticProvider("SessionUploadCountProvider");
            ((SimpleStatisticProvider)statisticProvider).increment(1);
            this.isUploadCounted = true;
        }
        this.uploadState.setStatus((short)2);
        object = this.uploadState.getUploadFile();
        this.raFile = new RandomAccessFile((File)object, "r");
        this.raFile.seek(this.fileStartOffset);
        statisticProvider = BandwidthManager.getInstance().getUploadBandwidthController();
        long l = 0L;
        int n = -1;
        byte[] byArray = new byte[1024];
        for (long i = this.endOffset - this.startOffset + 1L; i > 0L; i -= (long)n) {
            int n2 = (int)Math.min(i, 1024L);
            int n3 = ((BandwidthController)statisticProvider).demandBandwidth(n2);
            Logger.logMessage(Logger.FINER, (short)4, "Reading in " + n3 + " bytes at " + this.raFile.getFilePointer() + " from " + ((File)object).getName());
            n = this.raFile.read(byArray, 0, n3);
            if (n == -1) break;
            this.outStream.write(byArray, 0, n);
            this.uploadState.setTransferredDataSize(l += (long)n);
        }
        this.uploadState.setStatus((short)3);
    }

    private boolean evaluateHTTPRequest() throws IOException {
        HTTPResponse hTTPResponse;
        Object object;
        ShareFile shareFile;
        HTTPHeader hTTPHeader;
        Logger.logMessage(Logger.FINE, (short)4, "HTTP Request: " + this.httpRequest.buildHTTPRequestString());
        GnutellaRequest gnutellaRequest = this.httpRequest.getGnutellaRequest();
        this.isThexRequest = false;
        if (gnutellaRequest == null) {
            throw new IOException("Not a Gnutella file request.");
        }
        if (gnutellaRequest.getURN() == null && (hTTPHeader = this.httpRequest.getHeader("X-Gnutella-Content-URN")) != null && URN.isValidURN(hTTPHeader.getValue())) {
            URN uRN = new URN(hTTPHeader.getValue());
            gnutellaRequest.setContentURN(uRN);
        }
        int n = -1;
        hTTPHeader = this.httpRequest.getHeader("Listen-IP");
        if (hTTPHeader == null) {
            hTTPHeader = this.httpRequest.getHeader("X-My-Address");
        }
        if (hTTPHeader != null) {
            n = HostAddress.parsePort(hTTPHeader.getValue());
        }
        if (n <= 0) {
            n = this.socket.getPort();
        }
        this.hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), n);
        UploadManager uploadManager = UploadManager.getInstance();
        if (!this.isIPCounted) {
            boolean bl = uploadManager.validateAndCountIP(this.hostAddress);
            if (!bl) {
                HTTPResponse hTTPResponse2 = new HTTPResponse(503, "Upload Limit Reached for IP", true);
                this.sendHTTPResponse(hTTPResponse2);
                return false;
            }
            this.isIPCounted = true;
        }
        if ((shareFile = this.findShareFile(gnutellaRequest)) == null) {
            HTTPResponse hTTPResponse3 = new HTTPResponse(404, "File not found", true);
            this.sendHTTPResponse(hTTPResponse3);
            return false;
        }
        this.isUploadQueued = false;
        if (uploadManager.isHostBusy()) {
            hTTPHeader = this.httpRequest.getHeader("X-Queue");
            if (hTTPHeader == null || !ServiceManager.sCfg.allowUploadQueuing || uploadManager.isQueueLimitReached()) {
                HTTPResponse hTTPResponse4 = new HTTPResponse(503, "Upload Limit Reached", true);
                this.addAltLocResponseHeader(hTTPResponse4, shareFile);
                this.sendHTTPResponse(hTTPResponse4);
                return false;
            }
            this.isUploadQueued = true;
        }
        HTTPHeader hTTPHeader2 = null;
        HTTPRangeSet hTTPRangeSet = null;
        Range range = null;
        if (!this.isThexRequest) {
            short s;
            hTTPHeader2 = this.httpRequest.getHeader("Range");
            if (hTTPHeader2 != null) {
                hTTPRangeSet = HTTPRangeSet.parseHTTPRangeSet(hTTPHeader2.getValue());
                if (hTTPRangeSet == null) {
                    HTTPResponse hTTPResponse5 = new HTTPResponse(500, "Requested Range Not Parseable", true);
                    this.addAltLocResponseHeader(hTTPResponse5, shareFile);
                    this.sendHTTPResponse(hTTPResponse5);
                    return false;
                }
            } else {
                hTTPRangeSet = new HTTPRangeSet(0L, -1L);
            }
            if ((s = shareFile.getRangeAvailableStatus(range = hTTPRangeSet.getFirstRange())) != 0) {
                HTTPResponse hTTPResponse6 = s == 1 ? new HTTPResponse(503, "Requested Range Not Available", true) : new HTTPResponse(416, "Requested Range Not Satisfiable", true);
                if (shareFile instanceof PartialShareFile) {
                    PartialShareFile partialShareFile = (PartialShareFile)shareFile;
                    hTTPResponse6.addHeader(new HTTPHeader("X-Available-Ranges", partialShareFile.buildXAvailableRangesString()));
                }
                this.addAltLocResponseHeader(hTTPResponse6, shareFile);
                this.sendHTTPResponse(hTTPResponse6);
                return false;
            }
        }
        String string = null;
        hTTPHeader = this.httpRequest.getHeader("User-Agent");
        string = hTTPHeader != null ? hTTPHeader.getValue() : "";
        hTTPHeader = this.httpRequest.getHeader("Connection");
        this.isPersistentConnection = "HTTP/1.1".equals(this.httpRequest.getHTTPVersion()) ? hTTPHeader == null || !hTTPHeader.getValue().equalsIgnoreCase("CLOSE") : hTTPHeader != null && hTTPHeader.getValue().equalsIgnoreCase("KEEP-ALIVE");
        if (this.isUploadQueued) {
            int n2;
            if (this.uploadState == null) {
                this.uploadState = new UploadState(this.hostAddress, string);
                n2 = uploadManager.addQueuedUpload(this.uploadState) + 1;
            } else {
                this.uploadState.update(this.hostAddress, string);
                n2 = uploadManager.getQueuedPosition(this.uploadState) + 1;
            }
            this.uploadState.setStatus((short)1);
            int n3 = uploadManager.getUploadQueueSize();
            int n4 = ServiceManager.sCfg.mMaxUpload;
            int n5 = ServiceManager.sCfg.minUploadQueuePollTime;
            int n6 = ServiceManager.sCfg.maxUploadQueuePollTime;
            HTTPResponse hTTPResponse7 = new HTTPResponse(503, "Remotely Queued", true);
            this.addAltLocResponseHeader(hTTPResponse7, shareFile);
            XQueueParameters xQueueParameters = new XQueueParameters(n2, n3, n4, n5, n6);
            hTTPResponse7.addHeader(new HTTPHeader("X-Queue", xQueueParameters.buildHTTPString()));
            this.sendHTTPResponse(hTTPResponse7);
            this.socket.setSoTimeout(n6 * 1000);
            this.minNextPollTime = System.currentTimeMillis() + (long)(n5 * 1000);
            return true;
        }
        HTTPHeader hTTPHeader3 = null;
        long l = 0L;
        if (!this.isThexRequest) {
            if (shareFile instanceof PartialShareFile) {
                object = (PartialShareFile)shareFile;
                ((PartialShareFile)object).findFittingPartForRange(range);
                this.fileStartOffset = ((PartialShareFile)object).getFileStartOffset();
                hTTPHeader3 = new HTTPHeader("X-Available-Ranges", ((PartialShareFile)object).buildXAvailableRangesString());
            } else {
                this.fileStartOffset = range.getStartOffset(shareFile.getFileSize());
            }
            this.startOffset = range.getStartOffset(shareFile.getFileSize());
            this.endOffset = range.getEndOffset(shareFile.getFileSize());
            l = this.endOffset - this.startOffset + 1L;
        }
        object = shareFile.getURN();
        if (this.uploadState == null) {
            this.uploadState = this.isThexRequest ? new UploadState(this.hostAddress, string) : new UploadState(this.hostAddress, string, shareFile.getFileName(), (URN)object, shareFile.getSystemFile(), l);
            uploadManager.addUploadState(this.uploadState);
        } else if (this.isThexRequest) {
            this.uploadState.update(this.hostAddress, string);
        } else {
            this.uploadState.update(this.hostAddress, string, shareFile.getFileName(), (URN)object, shareFile.getSystemFile(), l);
        }
        this.uploadState.setUploadEngine(this);
        if (!this.isThexRequest) {
            hTTPResponse = this.startOffset == 0L && this.endOffset == shareFile.getFileSize() - 1L ? new HTTPResponse(200, "OK", true) : new HTTPResponse(206, "Partial Content", true);
            if (hTTPHeader3 != null) {
                hTTPResponse.addHeader(hTTPHeader3);
            }
        } else {
            hTTPResponse = new HTTPResponse(200, "OK", true);
        }
        hTTPResponse.addHeader(new HTTPHeader("Content-Type", "application/binary"));
        if (!this.isThexRequest) {
            hTTPResponse.addHeader(new HTTPHeader("Content-Length", String.valueOf(l)));
            hTTPResponse.addHeader(new HTTPHeader("Content-Range", "bytes " + this.startOffset + "-" + this.endOffset + "/" + shareFile.getFileSize()));
        }
        if (this.isPersistentConnection) {
            hTTPResponse.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        } else {
            hTTPResponse.addHeader(new HTTPHeader("Connection", "close"));
        }
        if (object != null) {
            hTTPResponse.addHeader(new HTTPHeader("X-Gnutella-Content-URN", ((URN)object).getAsString()));
        }
        if (!this.isThexRequest) {
            this.addAltLocResponseHeader(hTTPResponse, shareFile);
            this.addPushProxyResponseHeader(hTTPResponse);
        }
        if (object != null && !this.isThexRequest) {
            AlternateLocationContainer alternateLocationContainer = shareFile.getAltLocContainer();
            HTTPHeader[] hTTPHeaderArray = this.httpRequest.getHeaders("Alt-Location");
            alternateLocationContainer.addFromUriResHTTPHeaders(hTTPHeaderArray);
            hTTPHeaderArray = this.httpRequest.getHeaders("X-Gnutella-Alternate-Location");
            alternateLocationContainer.addFromUriResHTTPHeaders(hTTPHeaderArray);
            hTTPHeaderArray = this.httpRequest.getHeaders("X-Alt");
            alternateLocationContainer.addFromCompactIpHTTPHeaders(hTTPHeaderArray, (URN)object);
        }
        this.sendHTTPResponse(hTTPResponse);
        this.socket.setSoTimeout(ServiceManager.sCfg.socketConnectTimeout);
        if (this.uploadShareFile != null && !(shareFile instanceof PartialShareFile) && this.uploadShareFile != shareFile) {
            this.isUploadCounted = false;
        }
        this.uploadShareFile = shareFile;
        this.minNextPollTime = -1L;
        return true;
    }

    private void addAltLocResponseHeader(HTTPResponse hTTPResponse, ShareFile shareFile) {
        AlternateLocationContainer alternateLocationContainer = shareFile.getAltLocContainer();
        HTTPHeader hTTPHeader = alternateLocationContainer.getAltLocHTTPHeaderForAddress("X-Alt", this.hostAddress, this.sendAltLocSet);
        if (hTTPHeader != null) {
            hTTPResponse.addHeader(hTTPHeader);
        }
    }

    private void addPushProxyResponseHeader(HTTPResponse hTTPResponse) {
        HostManager hostManager = HostManager.getInstance();
        NetworkHostsContainer networkHostsContainer = hostManager.getNetworkHostsContainer();
        HostAddress[] hostAddressArray = networkHostsContainer.getPushProxies();
        if (hostAddressArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(4, hostAddressArray.length);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(hostAddressArray[i].getFullHostName());
        }
        if (stringBuffer.length() > 0) {
            HTTPHeader hTTPHeader = new HTTPHeader("X-Push-Proxy", stringBuffer.toString());
            hTTPResponse.addHeader(hTTPHeader);
        }
    }

    private void readNextHTTPRequest() throws IOException {
        try {
            this.httpRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            if (this.minNextPollTime > 0L && System.currentTimeMillis() < this.minNextPollTime) {
                throw new IOException("Queued host is requesting too soon.");
            }
        }
        catch (HTTPMessageException hTTPMessageException) {
            throw new IOException("Invalid HTTP Message: " + hTTPMessageException.getMessage());
        }
    }

    private void sendHTTPResponse(HTTPResponse hTTPResponse) throws IOException {
        String string = hTTPResponse.buildHTTPResponseString();
        Logger.logMessage(Logger.FINE, (short)4, "HTTP Response: " + string);
        this.outStream.write(string.getBytes());
    }

    private ShareFile findShareFile(GnutellaRequest gnutellaRequest) {
        ShareFile shareFile = null;
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        URN uRN = gnutellaRequest.getURN();
        if (uRN != null) {
            SwarmingManager swarmingManager;
            SWDownloadFile sWDownloadFile;
            if (!uRN.isSha1Nid()) {
                uRN = new URN("urn:sha1:" + uRN.getSHA1Nss());
            }
            if ((shareFile = sharedFilesService.getFileByURN(uRN)) == null && ServiceManager.sCfg.arePartialFilesShared && (sWDownloadFile = (swarmingManager = SwarmingManager.getInstance()).getDownloadFileByURN(uRN)) != null) {
                shareFile = new PartialShareFile(sWDownloadFile);
            }
        } else if (gnutellaRequest.getFileIndex() != -1) {
            int n = gnutellaRequest.getFileIndex();
            shareFile = sharedFilesService.getFileByIndex(n);
            if (shareFile != null) {
                String string = shareFile.getFileName();
                if (!gnutellaRequest.getFileName().equalsIgnoreCase(string)) {
                    Logger.logMessage(Logger.FINEST, (short)2, "Requested index '" + n + "' with filename '" + string + "' dosn't match request filename '" + gnutellaRequest.getFileName() + "'.");
                    shareFile = null;
                }
            } else if (gnutellaRequest.getFileName() != null) {
                shareFile = sharedFilesService.getFileByName(gnutellaRequest.getFileName());
            }
        }
        return shareFile;
    }
}

