/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.TransferRateService;
import phex.common.bandwidth.BandwidthManager;
import phex.download.HostBusyException;
import phex.event.AsynchronousDispatcher;
import phex.event.UploadFilesChangeListener;
import phex.host.HostAddress;
import phex.http.HTTPRequest;
import phex.net.connection.Connection;
import phex.upload.UploadEngine;
import phex.upload.UploadState;
import phex.utils.Logger;

public class UploadManager
implements Manager {
    private IPCounter uploadIPCounter;
    private ArrayList uploadStateList;
    private ArrayList queuedStateList;
    private TransferRateService transferRateService;
    private static UploadManager instance;
    private ArrayList listenerList = new ArrayList(2);

    private UploadManager() {
        this.uploadIPCounter = new IPCounter(ServiceManager.sCfg.mMaxUploadPerIP);
        this.uploadStateList = new ArrayList();
        this.queuedStateList = new ArrayList();
    }

    public static UploadManager getInstance() {
        if (instance == null) {
            instance = new UploadManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.transferRateService = BandwidthManager.getInstance().getTransferRateService();
        Environment.getInstance().scheduleTimerTask(new CleanUploadStateTimer(), 10000L, 10000L);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void handleUploadRequest(Connection connection, HTTPRequest hTTPRequest) throws IOException {
        UploadEngine uploadEngine = new UploadEngine(connection, hTTPRequest);
        uploadEngine.startUpload();
    }

    public boolean isHostBusy() {
        return this.getUploadingCount() >= ServiceManager.sCfg.mMaxUpload;
    }

    public boolean isQueueLimitReached() {
        return this.queuedStateList.size() >= ServiceManager.sCfg.maxUploadQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndCountIP(HostAddress hostAddress) throws HostBusyException {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            try {
                return this.uploadIPCounter.validateAndCountIP(hostAddress);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUploadIP(HostAddress hostAddress) {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            this.uploadIPCounter.relaseIP(hostAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadState(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.size();
            this.uploadStateList.add(n, uploadState);
            this.transferRateService.registerTransferDataProvider(uploadState);
            this.fireUploadFileAdded(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadListSize() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            return this.uploadStateList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingCount() {
        int n = 0;
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState uploadState = (UploadState)this.uploadStateList.get(i);
                if (uploadState.getStatus() != 2 && uploadState.getStatus() != 0) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState getUploadStateAt(int n) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.uploadStateList.size()) {
                return null;
            }
            return (UploadState)this.uploadStateList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState[] getUploadStatesAt(int[] nArray) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = nArray.length;
            UploadState[] uploadStateArray = new UploadState[n];
            int n2 = this.uploadStateList.size();
            for (int i = 0; i < n; ++i) {
                uploadStateArray[i] = nArray[i] < 0 || nArray[i] >= n2 ? null : (UploadState)this.uploadStateList.get(nArray[i]);
            }
            return uploadStateArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUploadState(UploadState uploadState) {
        int n;
        uploadState.stopUpload();
        this.transferRateService.unregisterTransferDataProvider(uploadState);
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            n = this.uploadStateList.indexOf(uploadState);
            if (n != -1) {
                this.uploadStateList.remove(n);
                this.fireUploadFileRemoved(n);
            }
        }
        arrayList = this.queuedStateList;
        synchronized (arrayList) {
            n = this.queuedStateList.indexOf(uploadState);
            if (n != -1) {
                this.queuedStateList.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUploadStateList() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState uploadState = (UploadState)this.uploadStateList.get(i);
                short s = uploadState.getStatus();
                if (s == 2 || s == 0) continue;
                this.transferRateService.unregisterTransferDataProvider(uploadState);
                this.uploadStateList.remove(i);
                this.fireUploadFileRemoved(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addQueuedUpload(UploadState uploadState) {
        int n;
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            n = this.queuedStateList.size();
            this.queuedStateList.add(n, uploadState);
        }
        this.fireUploadQueueChanged();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedUpload(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            int n = this.queuedStateList.indexOf(uploadState);
            if (n != -1) {
                this.queuedStateList.remove(n);
                this.fireUploadQueueChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedPosition(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.indexOf(uploadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadQueueSize() {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.size();
        }
    }

    public void addUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.add(uploadFilesChangeListener);
    }

    public void removeUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.remove(uploadFilesChangeListener);
    }

    private void fireUploadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileChanged(n);
                }
            }
        });
    }

    private void fireUploadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileAdded(n);
                }
            }
        });
    }

    private void fireUploadQueueChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadQueueChanged();
                }
            }
        });
    }

    private void fireUploadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileRemoved(n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUploadFileChanged(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.indexOf(uploadState);
            if (n >= 0) {
                this.fireUploadFileChanged(n);
            }
        }
    }

    private class CleanUploadStateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private CleanUploadStateTimer() {
        }

        public void run() {
            try {
                if (ServiceManager.sCfg.mUploadAutoRemoveCompleted) {
                    UploadManager.this.cleanUploadStateList();
                }
            }
            catch (Throwable throwable) {
                Logger.logError(throwable);
            }
        }
    }
}

